/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.sceneBuilder;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFxSettings;
import org.jetbrains.plugins.javaFX.JavaFxSettingsConfigurable;

public class SceneBuilderInfo {
    public static final SceneBuilderInfo EMPTY = new SceneBuilderInfo(null, null);
    public final String path;
    public final String libPath;

    private SceneBuilderInfo(String path, String libPath) {
        this.path = path;
        this.libPath = libPath;
    }

    public boolean equals(Object object) {
        if (object instanceof SceneBuilderInfo) {
            SceneBuilderInfo info = (SceneBuilderInfo)object;
            return Comparing.equal((String)this.path, (String)info.path) && Comparing.equal((String)this.libPath, (String)info.libPath);
        }
        return false;
    }

    @NotNull
    public static SceneBuilderInfo get(Project project, boolean choosePathIfEmpty) {
        File sceneBuilderLibsFile;
        JavaFxSettings settings = JavaFxSettings.getInstance();
        String pathToSceneBuilder = settings.getPathToSceneBuilder();
        if (StringUtil.isEmptyOrSpaces((String)pathToSceneBuilder) || !new File(pathToSceneBuilder).exists()) {
            VirtualFile sceneBuilderFile = null;
            if (choosePathIfEmpty) {
                sceneBuilderFile = FileChooser.chooseFile((FileChooserDescriptor)JavaFxSettingsConfigurable.createSceneBuilderDescriptor(), (Project)project, (VirtualFile)SceneBuilderInfo.getPredefinedPath());
            }
            if (sceneBuilderFile == null) {
                SceneBuilderInfo sceneBuilderInfo = EMPTY;
                if (sceneBuilderInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderInfo", "get"));
                }
                return sceneBuilderInfo;
            }
            pathToSceneBuilder = FileUtil.toSystemIndependentName((String)sceneBuilderFile.getPath());
            settings.setPathToSceneBuilder(pathToSceneBuilder);
        }
        if (SystemInfo.isMac) {
            sceneBuilderLibsFile = new File(new File(pathToSceneBuilder, "Contents"), "Java");
        } else if (SystemInfo.isWindows) {
            File libFile;
            File appFile;
            File foundInPath;
            File sceneBuilderRoot = new File(pathToSceneBuilder);
            File sceneBuilderRootDir = sceneBuilderRoot.getParentFile();
            if (sceneBuilderRootDir == null && (foundInPath = PathEnvironmentVariableUtil.findInPath((String)pathToSceneBuilder)) != null) {
                sceneBuilderRootDir = foundInPath.getParentFile();
            }
            File file = sceneBuilderRoot = sceneBuilderRootDir != null ? sceneBuilderRootDir.getParentFile() : null;
            sceneBuilderLibsFile = sceneBuilderRoot != null ? ((appFile = new File(sceneBuilderRootDir, "app")).isDirectory() ? appFile : ((libFile = new File(sceneBuilderRoot, "lib")).isDirectory() ? libFile : null)) : null;
        } else {
            sceneBuilderLibsFile = new File(new File(pathToSceneBuilder).getParent(), "app");
        }
        if (!(sceneBuilderLibsFile == null || sceneBuilderLibsFile.exists() && sceneBuilderLibsFile.isDirectory())) {
            sceneBuilderLibsFile = null;
        }
        SceneBuilderInfo sceneBuilderInfo = new SceneBuilderInfo(pathToSceneBuilder, sceneBuilderLibsFile == null ? null : sceneBuilderLibsFile.getAbsolutePath());
        if (sceneBuilderInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderInfo", "get"));
        }
        return sceneBuilderInfo;
    }

    @Nullable
    private static VirtualFile getPredefinedPath() {
        String path = null;
        if (SystemInfo.isWindows) {
            ArrayList<String> suspiciousPaths = new ArrayList<String>();
            String programFiles = "C:\\Program Files";
            String sb20 = "\\JavaFX Scene Builder 2.0\\JavaFX Scene Builder 2.0.exe";
            String sb11 = "\\JavaFX Scene Builder 1.1\\JavaFX Scene Builder 1.1.exe";
            String sb10 = "\\JavaFX Scene Builder 1.0\\bin\\scenebuilder.exe";
            SceneBuilderInfo.fillPaths(programFiles, suspiciousPaths, sb20, sb11, sb10);
            SceneBuilderInfo.fillPaths(programFiles + " (x86)", suspiciousPaths, sb20, sb11, sb10);
            path = SceneBuilderInfo.findFirstThatExist(ArrayUtil.toStringArray(suspiciousPaths));
        } else if (SystemInfo.isMac) {
            path = SceneBuilderInfo.findFirstThatExist("/Applications/JavaFX Scene Builder 2.0.app", "/Applications/JavaFX Scene Builder 1.1.app", "/Applications/JavaFX Scene Builder 1.0.app");
        } else if (SystemInfo.isUnix) {
            path = SceneBuilderInfo.findFirstThatExist("/opt/JavaFXSceneBuilder2.0/JavaFXSceneBuilder2.0", "/opt/JavaFXSceneBuilder1.1/JavaFXSceneBuilder1.1");
        }
        return path != null ? LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName(path)) : null;
    }

    private static String findFirstThatExist(String ... paths) {
        File sb = FileUtil.findFirstThatExist((String[])paths);
        return sb == null ? null : sb.getPath();
    }

    private static void fillPaths(String programFilesPath, List<String> suspiciousPaths, String ... sb) {
        for (String sbi : sb) {
            suspiciousPaths.add(new File(programFilesPath, "Oracle").getPath() + sbi);
        }
    }
}

