/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Alarm;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nullable;

public class NodeProgressAnimator
implements Runnable,
Disposable {
    private static final int FRAMES_COUNT = 8;
    private static final int MOVIE_TIME = 800;
    private static final int FRAME_TIME = 100;
    public static final Icon[] FRAMES = new Icon[8];
    private long myLastInvocationTime = -1L;
    private Alarm myAlarm;
    private SimpleNode myCurrentNode;
    private AbstractTreeBuilder myTreeBuilder;

    public NodeProgressAnimator(AbstractTreeBuilder builder) {
        Disposer.register((Disposable)builder, (Disposable)this);
        this.init(builder);
    }

    public static int getCurrentFrameIndex() {
        return (int)(System.currentTimeMillis() % 800L / 100L);
    }

    public static Icon getCurrentFrame() {
        return FRAMES[NodeProgressAnimator.getCurrentFrameIndex()];
    }

    protected void init(AbstractTreeBuilder treeBuilder) {
        this.myAlarm = new Alarm();
        this.myTreeBuilder = treeBuilder;
    }

    public SimpleNode getCurrentNode() {
        return this.myCurrentNode;
    }

    @Override
    public void run() {
        long time;
        if (this.myCurrentNode != null && (time = System.currentTimeMillis()) - this.myLastInvocationTime >= 100L) {
            this.repaintSubTree();
            this.myLastInvocationTime = time;
        }
        this.scheduleRepaint();
    }

    public void setCurrentNode(@Nullable SimpleNode node) {
        this.myCurrentNode = node;
        this.scheduleRepaint();
    }

    public void stopMovie() {
        this.repaintSubTree();
        this.setCurrentNode(null);
        this.cancelAlarm();
    }

    public void dispose() {
        this.myTreeBuilder = null;
        this.myCurrentNode = null;
        this.cancelAlarm();
    }

    private void cancelAlarm() {
        if (this.myAlarm != null) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm = null;
        }
    }

    private void repaintSubTree() {
        if (this.myTreeBuilder != null && this.myCurrentNode != null) {
            this.repaintWithParents(this.myCurrentNode);
        }
    }

    public void repaintWithParents(SimpleNode element) {
        SimpleNode current = element;
        do {
            DefaultMutableTreeNode node;
            if ((node = this.myTreeBuilder.getNodeForElement((Object)current)) == null) continue;
            AbstractTreeUi treeUi = this.myTreeBuilder.getUi();
            treeUi.addSubtreeToUpdate(node, false);
        } while ((current = current.getParent()) != null);
    }

    private void scheduleRepaint() {
        if (this.myAlarm == null) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        if (this.myCurrentNode != null) {
            this.myAlarm.addRequest((Runnable)this, 100);
        }
    }

    static {
        NodeProgressAnimator.FRAMES[0] = AllIcons.Process.State.GreyProgr_1;
        NodeProgressAnimator.FRAMES[1] = AllIcons.Process.State.GreyProgr_2;
        NodeProgressAnimator.FRAMES[2] = AllIcons.Process.State.GreyProgr_3;
        NodeProgressAnimator.FRAMES[3] = AllIcons.Process.State.GreyProgr_4;
        NodeProgressAnimator.FRAMES[4] = AllIcons.Process.State.GreyProgr_5;
        NodeProgressAnimator.FRAMES[5] = AllIcons.Process.State.GreyProgr_6;
        NodeProgressAnimator.FRAMES[6] = AllIcons.Process.State.GreyProgr_7;
        NodeProgressAnimator.FRAMES[7] = AllIcons.Process.State.GreyProgr_8;
    }
}

