/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleLog;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class GradleResolverUtil {
    public static int getGrMethodArumentsCount(@NotNull GrArgumentList args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "getGrMethodArumentsCount"));
        }
        int argsCount = 0;
        boolean namedArgProcessed = false;
        for (GroovyPsiElement arg : args.getAllArguments()) {
            if (arg instanceof GrNamedArgument) {
                if (namedArgProcessed) continue;
                namedArgProcessed = true;
                ++argsCount;
                continue;
            }
            ++argsCount;
        }
        return argsCount;
    }

    public static void addImplicitVariable(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull GrReferenceExpressionImpl expression, @NotNull String type) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "addImplicitVariable"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "addImplicitVariable"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "addImplicitVariable"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "addImplicitVariable"));
        }
        if (expression.getQualifier() == null && expression.getReferenceName() != null) {
            GrLightField myPsi = new GrLightField(expression.getReferenceName(), type, (PsiElement)expression);
            processor.execute((PsiElement)myPsi, state);
        }
    }

    public static void addImplicitVariable(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement element, @NotNull String type) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "addImplicitVariable"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "addImplicitVariable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "addImplicitVariable"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "addImplicitVariable"));
        }
        GrLightField myPsi = new GrLightField(element.getText(), type, element);
        processor.execute((PsiElement)myPsi, state);
    }

    @Nullable
    public static GrLightMethodBuilder createMethodWithClosure(@NotNull String name, @Nullable String returnType, @Nullable String closureTypeParameter, @NotNull PsiElement place, @NotNull GroovyPsiManager psiManager) {
        PsiClassType closureType;
        PsiClassType closureClassTypeParameter;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "createMethodWithClosure"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "createMethodWithClosure"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "createMethodWithClosure"));
        }
        PsiClass closureClass = psiManager.findClassWithCache("groovy.lang.Closure", place.getResolveScope());
        if (closureClass == null) {
            return null;
        }
        if (closureClass.getTypeParameters().length != 1) {
            GradleLog.LOG.debug(String.format("Unexpected type parameters found for closureClass(%s) : (%s)", closureClass, Arrays.toString(closureClass.getTypeParameters())));
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getManager().getProject());
        if (closureTypeParameter != null) {
            closureClassTypeParameter = factory.createTypeByFQClassName(closureTypeParameter, place.getResolveScope());
            closureType = factory.createType(closureClass, (PsiType)closureClassTypeParameter);
        } else {
            closureClassTypeParameter = factory.createTypeByFQClassName("java.lang.Object", place.getResolveScope());
            closureType = factory.createType(closureClass, (PsiType)closureClassTypeParameter);
        }
        GrLightMethodBuilder methodWithClosure = new GrLightMethodBuilder(place.getManager(), name);
        GrLightParameter closureParameter = new GrLightParameter("closure", (PsiType)closureType, (PsiElement)methodWithClosure);
        methodWithClosure.addParameter((GrParameter)closureParameter);
        PsiClassType retType = factory.createTypeByFQClassName(returnType != null ? returnType : "java.lang.Object", place.getResolveScope());
        methodWithClosure.setReturnType((PsiType)retType);
        methodWithClosure.setContainingClass(retType.resolve());
        return methodWithClosure;
    }

    public static void processMethod(@NotNull String methodName, @NotNull PsiClass handlerClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processMethod"));
        }
        if (handlerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlerClass", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processMethod"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processMethod"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processMethod"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processMethod"));
        }
        GradleResolverUtil.processMethod(methodName, handlerClass, processor, state, place, null);
    }

    public static void processMethod(@NotNull String methodName, @NotNull PsiClass handlerClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, @Nullable String defaultMethodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processMethod"));
        }
        if (handlerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlerClass", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processMethod"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processMethod"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processMethod"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processMethod"));
        }
        GrLightMethodBuilder builder = new GrLightMethodBuilder(place.getManager(), methodName);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getManager().getProject());
        PsiArrayType type = new PsiArrayType((PsiType)factory.createTypeByFQClassName("java.lang.Object", place.getResolveScope()));
        builder.addParameter((GrParameter)new GrLightParameter("param", (PsiType)type, (PsiElement)builder));
        PsiClassType retType = factory.createTypeByFQClassName("java.lang.Object", place.getResolveScope());
        builder.setReturnType((PsiType)retType);
        processor.execute((PsiElement)builder, state);
        GrMethodCall call = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethodCall.class);
        if (call == null) {
            return;
        }
        GrArgumentList args = call.getArgumentList();
        int argsCount = GradleResolverUtil.getGrMethodArumentsCount(args);
        ++argsCount;
        String setter = GroovyPropertyUtils.getSetterName((String)methodName);
        for (PsiMethod method : handlerClass.findMethodsByName(setter, false)) {
            if (method.getParameterList().getParametersCount() != 1) continue;
            builder.setNavigationElement((PsiElement)method);
            return;
        }
        for (PsiMethod method : handlerClass.findMethodsByName(methodName, false)) {
            if (method.getParameterList().getParametersCount() != argsCount) continue;
            builder.setNavigationElement((PsiElement)method);
            return;
        }
        if (defaultMethodName != null) {
            for (PsiMethod method : handlerClass.findMethodsByName(defaultMethodName, false)) {
                if (method.getParameterList().getParametersCount() != argsCount) continue;
                builder.setNavigationElement((PsiElement)method);
                return;
            }
        }
    }

    public static void processDeclarations(@NotNull GroovyPsiManager psiManager, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, String ... fqNames) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processDeclarations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processDeclarations"));
        }
        if (fqNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqNames", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processDeclarations"));
        }
        GradleResolverUtil.processDeclarations(null, psiManager, processor, state, place, fqNames);
    }

    public static void processDeclarations(@Nullable String methodName, @NotNull GroovyPsiManager psiManager, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, String ... fqNames) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processDeclarations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processDeclarations"));
        }
        if (fqNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqNames", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "processDeclarations"));
        }
        for (String fqName : fqNames) {
            PsiClass psiClass;
            if (fqName == null || (psiClass = psiManager.findClassWithCache(fqName, place.getResolveScope())) == null) continue;
            psiClass.processDeclarations(processor, state, null, place);
            if (methodName == null) continue;
            GradleResolverUtil.processMethod(methodName, psiClass, processor, state, place);
        }
    }

    @Nullable
    public static PsiElement findParent(@NotNull PsiElement element, int level) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "findParent"));
        }
        PsiElement parent = element;
        while ((parent = parent.getParent()) != null && --level > 0) {
        }
        return parent;
    }

    @Nullable
    public static <T extends PsiElement> T findParent(@NotNull PsiElement element, Class<T> clazz) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/gradle/service/resolve/GradleResolverUtil", "findParent"));
        }
        PsiElement parent = element;
        do {
            if (!clazz.isInstance(parent = parent.getParent())) continue;
            return (T)parent;
        } while (parent != null && !(parent instanceof GroovyFile));
        return null;
    }

    public static boolean canBeMethodOf(@Nullable String methodName, @Nullable PsiClass aClass) {
        return methodName != null && aClass != null && aClass.findMethodsByName(methodName, true).length != 0;
    }

    @Nullable
    public static PsiType getTypeOf(@Nullable GrExpression expression) {
        if (expression == null) {
            return null;
        }
        return (PsiType)RecursionManager.doPreventingRecursion((Object)expression, (boolean)true, () -> expression.getNominalType());
    }

    public static boolean isLShiftElement(@Nullable PsiElement psiElement) {
        return psiElement instanceof GrBinaryExpression && GroovyElementTypes.COMPOSITE_LSHIFT_SIGN.equals(((GrBinaryExpression)GrBinaryExpression.class.cast(psiElement)).getOperationTokenType());
    }
}

