/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.impl.compiler.JpsCompilerExcludesImpl;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerConfigurationSerializer;

public class JpsGroovySettings
extends JpsElementBase<JpsGroovySettings> {
    static final JpsElementChildRole<JpsGroovySettings> ROLE = JpsElementChildRoleBase.create((String)"Groovy Compiler Configuration");
    public static final String DEFAULT_HEAP_SIZE = "400";
    public static final boolean DEFAULT_INVOKE_DYNAMIC = false;
    public static final boolean DEFAULT_TRANSFORMS_OK = false;
    public String configScript = "";
    public String heapSize = "400";
    public boolean invokeDynamic = false;
    @Tag(value="excludes")
    public Element excludes = new Element("aaa");
    public boolean transformsOk = false;
    private JpsCompilerExcludes myExcludeFromStubGeneration;

    public JpsGroovySettings() {
    }

    private JpsGroovySettings(JpsGroovySettings original) {
        this.heapSize = original.heapSize;
        this.invokeDynamic = original.invokeDynamic;
        this.configScript = original.configScript;
    }

    void initExcludes() {
        this.myExcludeFromStubGeneration = new JpsCompilerExcludesImpl();
        JpsJavaCompilerConfigurationSerializer.readExcludes((Element)this.excludes, (JpsCompilerExcludes)this.myExcludeFromStubGeneration);
    }

    @NotNull
    public JpsGroovySettings createCopy() {
        JpsGroovySettings jpsGroovySettings = new JpsGroovySettings(this);
        if (jpsGroovySettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/JpsGroovySettings", "createCopy"));
        }
        return jpsGroovySettings;
    }

    public void applyChanges(@NotNull JpsGroovySettings modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/incremental/groovy/JpsGroovySettings", "applyChanges"));
        }
    }

    @NotNull
    public static JpsGroovySettings getSettings(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/incremental/groovy/JpsGroovySettings", "getSettings"));
        }
        JpsGroovySettings settings = (JpsGroovySettings)project.getContainer().getChild(ROLE);
        JpsGroovySettings jpsGroovySettings = settings == null ? new JpsGroovySettings() : settings;
        if (jpsGroovySettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/JpsGroovySettings", "getSettings"));
        }
        return jpsGroovySettings;
    }

    public boolean isExcludedFromStubGeneration(File file) {
        return this.myExcludeFromStubGeneration != null && this.myExcludeFromStubGeneration.isExcluded(file);
    }
}

