/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importer.colors;

import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importer.colors.EclipseColorThemeElements;
import org.jetbrains.idea.eclipse.importer.colors.EclipseThemeOptionHandler;
import org.jetbrains.idea.eclipse.importer.colors.EclipseThemeReader;

public class EclipseColorSchemeImporter
implements SchemeImporter<EditorColorsScheme>,
EclipseColorThemeElements {
    private static final String[] ECLIPSE_THEME_EXTENSIONS = new String[]{"xml"};
    private static final TextAttributesKey[] ATTRIBUTES_TO_COPY = new TextAttributesKey[]{HighlighterColors.BAD_CHARACTER, CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES, CodeInsightColors.ERRORS_ATTRIBUTES, CodeInsightColors.WARNINGS_ATTRIBUTES, CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING, CodeInsightColors.DUPLICATE_FROM_SERVER, CodeInsightColors.WEAK_WARNING_ATTRIBUTES, CodeInsightColors.INFORMATION_ATTRIBUTES, CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES, CodeInsightColors.DEPRECATED_ATTRIBUTES, CodeInsightColors.LINE_FULL_COVERAGE, CodeInsightColors.LINE_PARTIAL_COVERAGE, CodeInsightColors.LINE_NONE_COVERAGE, ConsoleViewContentType.NORMAL_OUTPUT_KEY, ConsoleViewContentType.ERROR_OUTPUT_KEY, ConsoleViewContentType.USER_INPUT_KEY, ConsoleViewContentType.SYSTEM_OUTPUT_KEY, ConsoleViewContentType.LOG_ERROR_OUTPUT_KEY, ConsoleViewContentType.LOG_WARNING_OUTPUT_KEY, ConsoleViewContentType.LOG_EXPIRED_ENTRY, ConsoleHighlighter.BLACK, ConsoleHighlighter.RED, ConsoleHighlighter.GREEN, ConsoleHighlighter.YELLOW, ConsoleHighlighter.BLUE, ConsoleHighlighter.MAGENTA, ConsoleHighlighter.CYAN, ConsoleHighlighter.GRAY, ConsoleHighlighter.DARKGRAY, ConsoleHighlighter.RED_BRIGHT, ConsoleHighlighter.GREEN_BRIGHT, ConsoleHighlighter.YELLOW_BRIGHT, ConsoleHighlighter.BLUE_BRIGHT, ConsoleHighlighter.MAGENTA_BRIGHT, ConsoleHighlighter.CYAN_BRIGHT, ConsoleHighlighter.WHITE, DiffColors.DIFF_ABSENT, DiffColors.DIFF_CONFLICT, DiffColors.DIFF_DELETED, DiffColors.DIFF_INSERTED, DiffColors.DIFF_MODIFIED, DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE, EditorColors.REFERENCE_HYPERLINK_COLOR, CodeInsightColors.HYPERLINK_ATTRIBUTES, CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES};
    private static final String[] EXTERNAL_ATTRIBUTES = new String[]{"BREAKPOINT_ATTRIBUTES", "EXECUTIONPOINT_ATTRIBUTES", "NOT_TOP_FRAME_ATTRIBUTES", "DEBUGGER_INLINED_VALUES", "DEBUGGER_INLINED_VALUES_MODIFIED", "DEBUGGER_INLINED_VALUES_EXECUTION_LINE"};

    @NotNull
    public String[] getSourceExtensions() {
        if (ECLIPSE_THEME_EXTENSIONS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter", "getSourceExtensions"));
        }
        return ECLIPSE_THEME_EXTENSIONS;
    }

    @Nullable
    public EditorColorsScheme importScheme(@NotNull Project project, @NotNull VirtualFile selectedFile, @NotNull EditorColorsScheme currentScheme, @NotNull SchemeFactory<EditorColorsScheme> schemeFactory) throws SchemeImportException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter", "importScheme"));
        }
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter", "importScheme"));
        }
        if (currentScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentScheme", "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter", "importScheme"));
        }
        if (schemeFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeFactory", "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter", "importScheme"));
        }
        String themeName = EclipseColorSchemeImporter.readSchemeName(selectedFile);
        if (themeName != null) {
            EditorColorsScheme colorsScheme = (EditorColorsScheme)schemeFactory.createNewScheme(themeName);
            EclipseColorSchemeImporter.readFromStream(selectedFile, new EclipseThemeOptionHandler(colorsScheme));
            EclipseColorSchemeImporter.setupMissingColors(colorsScheme);
            return colorsScheme;
        }
        return null;
    }

    private static String readSchemeName(@NotNull VirtualFile selectedFile) throws SchemeImportException {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter", "readSchemeName"));
        }
        return EclipseColorSchemeImporter.readFromStream(selectedFile, null);
    }

    private static String readFromStream(@NotNull VirtualFile file, @Nullable EclipseThemeReader.OptionHandler optionHandler) throws SchemeImportException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter", "readFromStream"));
        }
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            EclipseThemeReader themeReader = new EclipseThemeReader(optionHandler);
            themeReader.readSettings(inputStream);
            String string = themeReader.getThemeName();
            return string;
        }
        catch (IOException e) {
            throw new SchemeImportException((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Nullable
    public String getAdditionalImportInfo(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter", "getAdditionalImportInfo"));
        }
        return null;
    }

    private static void setupMissingColors(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter", "setupMissingColors"));
        }
        Color background = scheme.getDefaultBackground();
        String defaultSchemeName = ColorUtil.isDark((Color)background) ? "Darcula" : "Default";
        EditorColorsScheme baseScheme = DefaultColorSchemesManager.getInstance().getScheme(defaultSchemeName);
        assert (baseScheme != null) : "Can not find default scheme '" + defaultSchemeName + "'!";
        for (TextAttributesKey textAttributesKey : ATTRIBUTES_TO_COPY) {
            EclipseColorSchemeImporter.copyAttributes(baseScheme, scheme, textAttributesKey);
        }
        for (String string : EXTERNAL_ATTRIBUTES) {
            TextAttributesKey key = TextAttributesKey.createTextAttributesKey((String)string);
            EclipseColorSchemeImporter.copyAttributes(baseScheme, scheme, key);
        }
        Color color = ColorUtil.mix((Color)background, (Color)scheme.getDefaultForeground(), (double)0.5);
        scheme.setColor(EditorColors.WHITESPACES_COLOR, color);
        scheme.setColor(EditorColors.INDENT_GUIDE_COLOR, color);
        scheme.setColor(EditorColors.SOFT_WRAP_SIGN_COLOR, color);
        TextAttributes matchedBrace = new TextAttributes();
        matchedBrace.setEffectType(EffectType.BOXED);
        matchedBrace.setEffectColor(color);
        scheme.setAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES, matchedBrace);
        TextAttributes unmatchedBrace = matchedBrace.clone();
        unmatchedBrace.setEffectColor(ColorUtil.mix((Color)background, (Color)Color.RED, (double)0.5));
    }

    private static void copyAttributes(@NotNull EditorColorsScheme source, @NotNull EditorColorsScheme target, @NotNull TextAttributesKey key) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter", "copyAttributes"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter", "copyAttributes"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter", "copyAttributes"));
        }
        target.setAttributes(key, source.getAttributes(key));
    }
}

