/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.componentTree.ComponentPtr;
import com.intellij.uiDesigner.componentTree.ComponentSelectionListener;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public final class SelectionState {
    private final Stack<ComponentPtr[]> mySelectionHistory;
    private boolean myInsideChange;

    public SelectionState(@NotNull GuiEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/SelectionState", "<init>"));
        }
        this.mySelectionHistory = new Stack();
        editor.addComponentSelectionListener(new MyComponentSelectionListener());
    }

    public void setInsideChange(boolean insideChange) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myInsideChange = insideChange;
    }

    public Stack<ComponentPtr[]> getSelectionHistory() {
        return this.mySelectionHistory;
    }

    public static ComponentPtr[] getSelection(GuiEditor editor) {
        ArrayList<RadComponent> selection = FormEditingUtil.getAllSelectedComponents(editor);
        ComponentPtr[] ptrs = new ComponentPtr[selection.size()];
        for (int i = selection.size() - 1; i >= 0; --i) {
            ptrs[i] = new ComponentPtr(editor, selection.get(i));
        }
        return ptrs;
    }

    public static void restoreSelection(GuiEditor editor, ComponentPtr[] ptrs) {
        FormEditingUtil.clearSelection(editor.getRootContainer());
        for (int i = ptrs.length - 1; i >= 0; --i) {
            ComponentPtr ptr = ptrs[i];
            ptr.validate();
            if (!ptr.isValid()) continue;
            ptr.getComponent().setSelected(true);
        }
    }

    private final class MyComponentSelectionListener
    implements ComponentSelectionListener {
        private MyComponentSelectionListener() {
        }

        @Override
        public void selectedComponentChanged(GuiEditor source) {
            if (SelectionState.this.myInsideChange) {
                return;
            }
            SelectionState.this.mySelectionHistory.clear();
            SelectionState.this.mySelectionHistory.push(SelectionState.getSelection(source));
        }
    }
}

