/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Property<T extends RadComponent, V>
implements IProperty {
    public static final Property[] EMPTY_ARRAY = new Property[0];
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.propertyInspector.Property");
    private final Property myParent;
    private final String myName;

    public Property(Property parent, @NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/uiDesigner/propertyInspector/Property", "<init>"));
        }
        this.myParent = parent;
        this.myName = name;
    }

    @NotNull
    public final String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/Property", "getName"));
        }
        return string;
    }

    public Object getPropertyValue(IComponent component) {
        return this.getValue((RadComponent)component);
    }

    public abstract V getValue(T var1);

    protected abstract void setValueImpl(T var1, V var2) throws Exception;

    public final void setValue(T component, V value) throws Exception {
        this.setValueImpl(component, value);
        this.markTopmostModified(component, true);
        ((RadComponent)component).getDelegee().invalidate();
    }

    public final void setValueEx(T component, V value) {
        try {
            this.setValue(component, value);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
    }

    protected void markTopmostModified(T component, boolean modified) {
        Property topmostParent = this;
        while (topmostParent.getParent() != null) {
            topmostParent = topmostParent.getParent();
        }
        if (modified) {
            ((RadComponent)component).markPropertyAsModified(topmostParent);
        } else {
            ((RadComponent)component).removeModifiedProperty(topmostParent);
        }
    }

    @Nullable
    public final Property getParent() {
        return this.myParent;
    }

    @NotNull
    public Property[] getChildren(RadComponent component) {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/Property", "getChildren"));
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    public abstract PropertyRenderer<V> getRenderer();

    @Nullable
    public abstract PropertyEditor<V> getEditor();

    public boolean appliesTo(T component) {
        return true;
    }

    public boolean isModified(T component) {
        return false;
    }

    public void resetValue(T component) throws Exception {
    }

    public boolean appliesToSelection(List<RadComponent> selection) {
        return true;
    }

    public boolean needRefreshPropertyList() {
        return false;
    }
}

