/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.wizard;

import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.uiDesigner.wizard.BindToExistingBeanStep;
import com.intellij.uiDesigner.wizard.BindToNewBeanStep;
import com.intellij.uiDesigner.wizard.WizardData;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class BindCompositeStep
extends StepAdapter {
    private final WizardData myData;
    private final JPanel myCardHolder;
    private final BindToNewBeanStep myBindToNewBeanStep;
    private final BindToExistingBeanStep myBindToExistingBeanStep;
    @NonNls
    private static final String CARD_NEW_BEAN = "newBean";
    @NonNls
    private static final String CARD_EXISTING_BEAN = "existingBean";

    BindCompositeStep(@NotNull WizardData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/uiDesigner/wizard/BindCompositeStep", "<init>"));
        }
        this.myData = data;
        this.myBindToNewBeanStep = new BindToNewBeanStep(data);
        this.myBindToExistingBeanStep = new BindToExistingBeanStep(data);
        this.myCardHolder = new JPanel(new CardLayout());
        this.myCardHolder.add((Component)this.myBindToNewBeanStep.getComponent(), CARD_NEW_BEAN);
        this.myCardHolder.add((Component)this.myBindToExistingBeanStep.getComponent(), CARD_EXISTING_BEAN);
    }

    public JComponent getComponent() {
        return this.myCardHolder;
    }

    public void _init() {
        if (this.myData.myBindToNewBean) {
            this.myBindToNewBeanStep._init();
            CardLayout layout = (CardLayout)this.myCardHolder.getLayout();
            layout.show(this.myCardHolder, CARD_NEW_BEAN);
        } else {
            this.myBindToExistingBeanStep._init();
            CardLayout layout = (CardLayout)this.myCardHolder.getLayout();
            layout.show(this.myCardHolder, CARD_EXISTING_BEAN);
        }
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        if (this.myData.myBindToNewBean) {
            this.myBindToNewBeanStep._commit(finishChosen);
        } else {
            this.myBindToExistingBeanStep._commit(finishChosen);
        }
    }
}

