/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.vintage.engine.discovery.RunnerTestDescriptorAwareFilter;
import org.junit.vintage.engine.discovery.TestClassRequest;

class TestClassCollector {
    private final Set<Class<?>> completeTestClasses = new LinkedHashSet();
    private final Map<Class<?>, List<RunnerTestDescriptorAwareFilter>> filteredTestClasses = new LinkedHashMap();

    TestClassCollector() {
    }

    void addCompletely(Class<?> testClass) {
        this.completeTestClasses.add(testClass);
    }

    void addFiltered(Class<?> testClass, RunnerTestDescriptorAwareFilter filter) {
        this.filteredTestClasses.computeIfAbsent(testClass, key -> new LinkedList()).add(filter);
    }

    Set<TestClassRequest> toRequests(Predicate<? super Class<?>> predicate) {
        return Stream.concat(this.completeRequests(predicate), this.filteredRequests(predicate)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Stream<TestClassRequest> completeRequests(Predicate<? super Class<?>> predicate) {
        return this.completeTestClasses.stream().filter(predicate).map(TestClassRequest::new);
    }

    private Stream<TestClassRequest> filteredRequests(Predicate<? super Class<?>> predicate) {
        return this.filteredTestClasses.entrySet().stream().filter(FunctionUtils.where(Map.Entry::getKey, testClass -> !this.completeTestClasses.contains(testClass))).filter(FunctionUtils.where(Map.Entry::getKey, predicate)).map(entry -> new TestClassRequest((Class)entry.getKey(), (List)entry.getValue()));
    }
}

