/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public class YAMLQuotedTextImpl
extends YAMLScalarImpl
implements YAMLQuotedText {
    private final boolean myIsSingleQuoted;

    public YAMLQuotedTextImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "<init>"));
        }
        super(node);
        this.myIsSingleQuoted = this.getNode().getFirstChildNode().getElementType() == YAMLTokenTypes.SCALAR_STRING;
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        List lines = StringUtil.split((String)this.getText(), (String)"\n", (boolean)true, (boolean)false);
        int cumulativeOffset = 0;
        for (int i = 0; i < lines.size(); ++i) {
            int lineStart;
            String line = (String)lines.get(i);
            int lineEnd = line.length();
            if (i == 0) {
                ++lineStart;
            } else {
                for (lineStart = 0; lineStart < line.length() && YAMLGrammarCharUtil.isSpaceLike(line.charAt(lineStart)); ++lineStart) {
                }
            }
            if (i == lines.size() - 1) {
                --lineEnd;
            } else {
                while (lineEnd > lineStart && YAMLGrammarCharUtil.isSpaceLike(line.charAt(lineEnd - 1))) {
                    --lineEnd;
                }
            }
            result.add(TextRange.create((int)lineStart, (int)lineEnd).shiftRight(cumulativeOffset));
            cumulativeOffset += line.length() + 1;
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getContentRanges"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence leftString, @NotNull CharSequence rightString) {
        if (leftString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftString", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getRangesJoiner"));
        }
        if (rightString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightString", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getRangesJoiner"));
        }
        if (leftString.length() == 0 || !this.isSingleQuote() && leftString.charAt(leftString.length() - 1) == '\\') {
            if ("\n" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getRangesJoiner"));
            }
            return "\n";
        }
        if (rightString.length() == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getRangesJoiner"));
            }
            return "";
        }
        if (" " == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getRangesJoiner"));
        }
        return " ";
    }

    @Override
    protected List<Pair<TextRange, String>> getDecodeReplacements(@NotNull CharSequence input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getDecodeReplacements"));
        }
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int i = 0;
        while (i + 1 < input.length()) {
            CharSequence subSequence = input.subSequence(i, i + 2);
            TextRange textRange = TextRange.create((int)i, (int)(i + 2));
            if (this.isSingleQuote() && "''".equals(subSequence)) {
                result.add((Pair<TextRange, String>)Pair.create((Object)textRange, (Object)"'"));
            } else if (!this.isSingleQuote() && "\\\n".equals(subSequence)) {
                result.add((Pair<TextRange, String>)Pair.create((Object)textRange, (Object)""));
            } else if (!this.isSingleQuote() && "\\ ".equals(subSequence)) {
                result.add((Pair<TextRange, String>)Pair.create((Object)textRange, (Object)" "));
            } else if (!this.isSingleQuote() && "\\\"".equals(subSequence)) {
                result.add((Pair<TextRange, String>)Pair.create((Object)textRange, (Object)"\""));
            } else {
                --i;
            }
            ++i;
            ++i;
        }
        return result;
    }

    @Override
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getEncodeReplacements"));
        }
        if (this.isSingleQuote()) {
            for (int i = 0; i < input.length(); ++i) {
                if (input.charAt(i) != '\n' || YAMLQuotedTextImpl.isSurroundedByNoSpace(input, i)) continue;
                throw new IllegalArgumentException("Newlines with spaces around are not convertible");
            }
        }
        int indent = YAMLUtil.getIndentToThisElement((PsiElement)this);
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int currentLength = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\n') {
                if (!this.isSingleQuote() && i + 1 < input.length() && YAMLGrammarCharUtil.isSpaceLike(input.charAt(i + 1))) {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\\\n" + indentString + "\\")));
                } else {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n\n" + indentString)));
                }
                currentLength = 0;
                continue;
            }
            if (currentLength > 60 && (!this.isSingleQuote() || input.charAt(i) == ' ' && YAMLQuotedTextImpl.isSurroundedByNoSpace(input, i))) {
                String replacement = this.isSingleQuote() ? "\n" + indentString : (YAMLGrammarCharUtil.isSpaceLike(input.charAt(i)) ? "\\\n" + indentString + "\\" : "\\\n" + indentString);
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)(this.isSingleQuote() ? 1 : 0)), (Object)replacement));
                currentLength = 0;
            }
            ++currentLength;
            if (this.isSingleQuote() && input.charAt(i) == '\'') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)"''"));
                continue;
            }
            if (this.isSingleQuote()) continue;
            if (input.charAt(i) == '\"') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)"\\\""));
                continue;
            }
            if (input.charAt(i) != '\\') continue;
            result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)"\\\\"));
        }
        return result;
    }

    @Override
    public boolean isMultiline() {
        return this.textContains('\n');
    }

    @Override
    public boolean isSingleQuote() {
        return this.myIsSingleQuoted;
    }

    @Override
    public String toString() {
        return "YAML quoted text";
    }
}

