/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Processor;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.services.MavenRepositoryServicesManager;
import org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler;

public class MavenRepositoriesConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final MavenProjectIndicesManager myManager;
    private JPanel myMainPanel;
    private JBTable myIndicesTable;
    private JButton myUpdateButton;
    private JButton myRemoveButton;
    private JButton myAddButton;
    private JBList myServiceList;
    private JButton myTestButton;
    private JButton myEditButton;
    private AnimatedIcon myUpdatingIcon;
    private Timer myRepaintTimer;
    private ActionListener myTimerListener;
    private final Project myProject;
    private final CollectionListModel<String> myModel;

    public MavenRepositoriesConfigurable(Project project) {
        Object[] objectArray = new String[]{};
        this.$$$setupUI$$$();
        this.myModel = new CollectionListModel(objectArray);
        this.myProject = project;
        this.myManager = MavenProjectIndicesManager.getInstance(project);
        this.configControls();
    }

    public boolean isModified() {
        return !this.myModel.getItems().equals(MavenRepositoryServicesManager.getInstance().getUrls());
    }

    private void configControls() {
        this.myServiceList.setModel(this.myModel);
        this.myServiceList.setSelectionMode(0);
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = (String)MavenRepositoriesConfigurable.this.myServiceList.getSelectedValue();
                String text = Messages.showInputDialog((String)"Artifactory or Nexus Service URL", (String)"Add Service URL", (Icon)Messages.getQuestionIcon(), (String)(value == null ? "http://" : value), (InputValidator)new URLInputVaslidator());
                if (StringUtil.isNotEmpty((String)text)) {
                    MavenRepositoriesConfigurable.this.myModel.add((Object)text);
                    MavenRepositoriesConfigurable.this.myServiceList.setSelectedValue((Object)text, true);
                }
            }
        });
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = MavenRepositoriesConfigurable.this.myServiceList.getSelectedIndex();
                String text = Messages.showInputDialog((String)"Artifactory or Nexus Service URL", (String)"Edit Service URL", (Icon)Messages.getQuestionIcon(), (String)((String)MavenRepositoriesConfigurable.this.myModel.getElementAt(index)), (InputValidator)new URLInputVaslidator());
                if (StringUtil.isNotEmpty((String)text)) {
                    MavenRepositoriesConfigurable.this.myModel.setElementAt((Object)text, index);
                }
            }
        });
        ListUtil.addRemoveListener((JButton)this.myRemoveButton, (JList)this.myServiceList);
        ListUtil.disableWhenNoSelection((JButton)this.myTestButton, (JList)this.myServiceList);
        ListUtil.disableWhenNoSelection((JButton)this.myEditButton, (JList)this.myServiceList);
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = (String)MavenRepositoriesConfigurable.this.myServiceList.getSelectedValue();
                if (value != null) {
                    MavenRepositoriesConfigurable.this.testServiceConnection(value);
                }
            }
        });
        this.myUpdateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenRepositoriesConfigurable.this.doUpdateIndex();
            }
        });
        this.myIndicesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MavenRepositoriesConfigurable.this.updateButtonsState();
            }
        });
        this.myIndicesTable.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = MavenRepositoriesConfigurable.this.myIndicesTable.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                MavenRepositoriesConfigurable.this.updateIndexHint(row);
            }
        });
        this.myIndicesTable.setDefaultRenderer(Object.class, (TableCellRenderer)new MyCellRenderer());
        this.myIndicesTable.setDefaultRenderer(MavenIndicesManager.IndexUpdatingState.class, (TableCellRenderer)new MyIconCellRenderer());
        this.myServiceList.getEmptyText().setText("No services");
        this.myIndicesTable.getEmptyText().setText("No remote repositories");
        this.updateButtonsState();
    }

    private void testServiceConnection(String url) {
        this.myTestButton.setEnabled(false);
        RepositoryAttachHandler.searchRepositories(this.myProject, Collections.singletonList(url), (Processor<Collection<MavenRepositoryInfo>>)((Processor)infos -> {
            this.myTestButton.setEnabled(true);
            if (infos.isEmpty()) {
                Messages.showMessageDialog((String)"No repositories found", (String)"Service Connection Failed", (Icon)Messages.getWarningIcon());
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(infos.size()).append(infos.size() == 1 ? "repository" : " repositories").append(" found");
                Messages.showMessageDialog((String)sb.toString(), (String)"Service Connection Successful", (Icon)Messages.getInformationIcon());
            }
            return true;
        }));
    }

    private void updateButtonsState() {
        boolean hasSelection = !this.myIndicesTable.getSelectionModel().isSelectionEmpty();
        this.myUpdateButton.setEnabled(hasSelection);
    }

    public void updateIndexHint(int row) {
        MavenIndex index = this.getIndexAt(row);
        String message = index.getFailureMessage();
        if (message == null) {
            this.myIndicesTable.setToolTipText(null);
        } else {
            this.myIndicesTable.setToolTipText(message);
        }
    }

    private void doUpdateIndex() {
        this.myManager.scheduleUpdate(this.getSelectedIndices());
    }

    private List<MavenIndex> getSelectedIndices() {
        ArrayList<MavenIndex> result = new ArrayList<MavenIndex>();
        for (int i : this.myIndicesTable.getSelectedRows()) {
            result.add(this.getIndexAt(i));
        }
        return result;
    }

    private MavenIndex getIndexAt(int i) {
        MyTableModel model = (MyTableModel)this.myIndicesTable.getModel();
        return model.getIndex(i);
    }

    public String getDisplayName() {
        return IndicesBundle.message("maven.repositories.title", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.project.maven.repository.indices";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/indices/MavenRepositoriesConfigurable", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public void apply() throws ConfigurationException {
        MavenRepositoryServicesManager.getInstance().setUrls(this.myModel.getItems());
    }

    public void reset() {
        this.myModel.removeAll();
        this.myModel.add(MavenRepositoryServicesManager.getInstance().getUrls());
        this.myIndicesTable.setModel((TableModel)new MyTableModel(this.myManager.getIndices()));
        this.myIndicesTable.getColumnModel().getColumn(0).setPreferredWidth(400);
        this.myIndicesTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.myIndicesTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.myIndicesTable.getColumnModel().getColumn(3).setPreferredWidth(20);
        this.myUpdatingIcon = new AsyncProcessIcon(IndicesBundle.message("maven.indices.updating", new Object[0]));
        this.myUpdatingIcon.resume();
        this.myTimerListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenRepositoriesConfigurable.this.myIndicesTable.repaint();
            }
        };
        this.myRepaintTimer = UIUtil.createNamedTimer((String)"Maven repaint", (int)66, (ActionListener)this.myTimerListener);
        this.myRepaintTimer.start();
    }

    public void disposeUIResources() {
        if (this.myRepaintTimer == null) {
            return;
        }
        this.myRepaintTimer.removeActionListener(this.myTimerListener);
        this.myRepaintTimer.stop();
        Disposer.dispose((Disposable)this.myUpdatingIcon);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JBList jBList;
        JButton jButton5;
        JBTable jBTable;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Indexed Maven Repositories", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myIndicesTable = jBTable = new JBTable();
        jBScrollPane.setViewportView((Component)jBTable);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUpdateButton = jButton5 = new JButton();
        jButton5.setFocusable(false);
        jButton5.setText("Update");
        jButton5.setMnemonic('U');
        jButton5.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Artifactory or Nexus Service URLs:", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 4, 0, null, new Dimension(406, 128), null));
        this.myServiceList = jBList = new JBList();
        jBList.setLayoutOrientation(0);
        jBScrollPane2.setViewportView((Component)jBList);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 4, 2, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAddButton = jButton4 = new JButton();
        jButton4.setFocusable(false);
        jButton4.setText("Add");
        jButton4.setMnemonic('A');
        jButton4.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton3 = new JButton();
        jButton3.setText("Remove");
        jButton3.setMnemonic('R');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton3, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTestButton = jButton2 = new JButton();
        jButton2.setText("Test");
        jButton2.setMnemonic('T');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton2, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEditButton = jButton = new JButton();
        jButton.setText("Edit");
        jButton.setMnemonic('E');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class URLInputVaslidator
    implements InputValidator {
        private URLInputVaslidator() {
        }

        public boolean checkInput(String inputString) {
            try {
                URL url = new URL(inputString);
                return StringUtil.isNotEmpty((String)url.getHost());
            }
            catch (MalformedURLException e) {
                return false;
            }
        }

        public boolean canClose(String inputString) {
            return this.checkInput(inputString);
        }
    }

    private class MyIconCellRenderer
    extends MyCellRenderer {
        MavenIndicesManager.IndexUpdatingState myState;

        private MyIconCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myState = (MavenIndicesManager.IndexUpdatingState)((Object)value);
            return super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension size = this.getSize();
            switch (this.myState) {
                case UPDATING: {
                    MavenRepositoriesConfigurable.this.myUpdatingIcon.setBackground(this.getBackground());
                    MavenRepositoriesConfigurable.this.myUpdatingIcon.setSize(size.width, size.height);
                    MavenRepositoriesConfigurable.this.myUpdatingIcon.paint(g);
                    break;
                }
                case WAITING: {
                    int x = (size.width - AllIcons.Process.Step_passive.getIconWidth()) / 2;
                    int y = (size.height - AllIcons.Process.Step_passive.getIconHeight()) / 2;
                    AllIcons.Process.Step_passive.paintIcon(this, g, x, y);
                }
            }
        }
    }

    private class MyCellRenderer
    extends DefaultTableCellRenderer {
        private MyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(null);
            this.setBackground(null);
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            MavenIndex index = MavenRepositoriesConfigurable.this.getIndexAt(row);
            if (index.getFailureMessage() != null) {
                if (isSelected) {
                    this.setForeground((Color)JBColor.PINK);
                } else {
                    this.setBackground((Color)JBColor.PINK);
                }
            }
            return c;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private final String[] COLUMNS = new String[]{IndicesBundle.message("maven.index.url", new Object[0]), IndicesBundle.message("maven.index.type", new Object[0]), IndicesBundle.message("maven.index.updated", new Object[0]), ""};
        private final List<MavenIndex> myIndices;

        public MyTableModel(List<MavenIndex> indices) {
            this.myIndices = indices;
        }

        @Override
        public int getColumnCount() {
            return this.COLUMNS.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.COLUMNS[index];
        }

        @Override
        public int getRowCount() {
            return this.myIndices.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return MavenIndicesManager.IndexUpdatingState.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MavenIndex i = this.getIndex(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return i.getRepositoryPathOrUrl();
                }
                case 1: {
                    if (i.getKind() == MavenIndex.Kind.LOCAL) {
                        return "Local";
                    }
                    return "Remote";
                }
                case 2: {
                    if (i.getFailureMessage() != null) {
                        return IndicesBundle.message("maven.index.updated.error", new Object[0]);
                    }
                    long timestamp = i.getUpdateTimestamp();
                    if (timestamp == -1L) {
                        return IndicesBundle.message("maven.index.updated.never", new Object[0]);
                    }
                    return DateFormatUtil.formatDate((long)timestamp);
                }
                case 3: {
                    return MavenRepositoriesConfigurable.this.myManager.getUpdatingState(i);
                }
            }
            throw new RuntimeException();
        }

        public MavenIndex getIndex(int rowIndex) {
            return this.myIndices.get(rowIndex);
        }
    }
}

