/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.math.BigInteger;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.DescribedNode;
import lombok.ast.Expression;
import lombok.ast.Literal;
import lombok.ast.LiteralType;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;

public class IntegralLiteral
extends AbstractNode.WithParens
implements Literal,
Expression,
DescribedNode {
    private static final String NEGATIVE_NUMBERS_NOT_POSSIBLE = "Negative integral literals don't exist; wrap in a UnaryExpression with operator MINUS";
    private Long value;
    private String rawValue;
    private String errorReasonForValue = "Missing value";
    private boolean markedAsLong;
    private LiteralType literalType = LiteralType.DECIMAL;
    private static final BigInteger MAX_UNSIGNED_LONG = new BigInteger("FFFFFFFFFFFFFFFF", 16);

    @Override
    public boolean isStatementExpression() {
        return false;
    }

    @Override
    public String getDescription() {
        return this.value != null ? String.valueOf(this.value) : null;
    }

    public String getErrorReasonForValue() {
        if (this.errorReasonForValue != null) {
            return this.errorReasonForValue;
        }
        long v = this.value;
        if (this.markedAsLong) {
            if (this.literalType != LiteralType.DECIMAL) {
                return null;
            }
            if (v >= 0L) {
                return null;
            }
            if (v == Long.MIN_VALUE) {
                return this.containedInUnaryMinus() ? null : "Long literal too large: " + this.rawValue;
            }
            return NEGATIVE_NUMBERS_NOT_POSSIBLE;
        }
        if ((v & 0xFFFFFFFF00000000L) != 0L) {
            return "Int literal too large: " + this.rawValue;
        }
        if (this.literalType != LiteralType.DECIMAL) {
            return null;
        }
        if (v <= Integer.MAX_VALUE) {
            return null;
        }
        if (v == 0x80000000L) {
            return this.containedInUnaryMinus() ? null : "Int literal too large: " + this.rawValue;
        }
        return NEGATIVE_NUMBERS_NOT_POSSIBLE;
    }

    private boolean containedInUnaryMinus() {
        return this.getParens() == 0 && this.getParent() instanceof UnaryExpression && ((UnaryExpression)this.getParent()).astOperator() == UnaryOperator.UNARY_MINUS;
    }

    public static Expression ofInt(int value) {
        IntegralLiteral v = new IntegralLiteral();
        if (value < 0) {
            return new UnaryExpression().astOperator(UnaryOperator.UNARY_MINUS).astOperand(v.astIntValue(-value));
        }
        return v.astIntValue(value);
    }

    public static Expression ofLong(long value) {
        IntegralLiteral v = new IntegralLiteral();
        if (value < 0L) {
            return new UnaryExpression().astOperator(UnaryOperator.UNARY_MINUS).astOperand(v.astLongValue(-value));
        }
        return v.astLongValue(value);
    }

    public LiteralType astLiteralType() {
        return this.literalType;
    }

    public IntegralLiteral astLiteralType(LiteralType type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.literalType = type;
        this.updateRawValue();
        return this;
    }

    public boolean astMarkedAsLong() {
        return this.markedAsLong;
    }

    public IntegralLiteral astMarkedAsLong(boolean marked) {
        this.markedAsLong = marked;
        this.updateRawValue();
        return this;
    }

    @Override
    public IntegralLiteral copy() {
        IntegralLiteral result = new IntegralLiteral();
        result.value = this.value;
        result.rawValue = this.rawValue;
        result.errorReasonForValue = this.errorReasonForValue;
        result.markedAsLong = this.markedAsLong;
        result.literalType = this.literalType;
        return result;
    }

    public IntegralLiteral astIntValue(int value) {
        this.value = (long)value & 0xFFFFFFFFL;
        this.rawValue = "" + value;
        this.errorReasonForValue = null;
        this.markedAsLong = false;
        this.updateRawValue();
        return this;
    }

    public IntegralLiteral astLongValue(long value) {
        this.value = value;
        this.rawValue = "" + value + "L";
        this.errorReasonForValue = null;
        this.markedAsLong = true;
        this.updateRawValue();
        return this;
    }

    private void updateRawValue() {
        if (this.errorReasonForValue != null) {
            return;
        }
        String suffix = this.markedAsLong ? "L" : "";
        switch (this.literalType) {
            case DECIMAL: {
                this.rawValue = (this.value < 0L ? String.valueOf(this.value).substring(1) : this.value) + suffix;
                break;
            }
            case HEXADECIMAL: {
                int nibbleCounter;
                StringBuilder out = new StringBuilder(19);
                out.append("0x");
                boolean nulls = true;
                int n = nibbleCounter = this.markedAsLong ? 60 : 28;
                while (nibbleCounter >= 0) {
                    int nibble = (int)(this.value >>> nibbleCounter) & 0xF;
                    if (!nulls || nibble != 0 || nibbleCounter == 0) {
                        nulls = false;
                        out.append((char)(nibble < 10 ? 48 + nibble : 87 + nibble));
                    }
                    nibbleCounter -= 4;
                }
                out.append(suffix);
                this.rawValue = out.toString();
                break;
            }
            case OCTAL: {
                int nibbleCounter;
                StringBuilder out = new StringBuilder(25);
                out.append("0");
                boolean nulls = true;
                if (this.markedAsLong) {
                    if ((this.value & Long.MIN_VALUE) != 0L) {
                        out.append("1");
                        nulls = false;
                    }
                    nibbleCounter = 60;
                } else {
                    int halfNibble = (int)(this.value >>> 30) & 3;
                    if (halfNibble != 0) {
                        out.append((char)(48 + halfNibble));
                        nulls = false;
                    }
                    nibbleCounter = 27;
                }
                while (nibbleCounter >= 0) {
                    int nibble = (int)(this.value >>> nibbleCounter) & 7;
                    if (!nulls || nibble != 0 || nibbleCounter == 0) {
                        nulls = false;
                        out.append((char)(48 + nibble));
                    }
                    nibbleCounter -= 3;
                }
                out.append(suffix);
                this.rawValue = out.toString();
                break;
            }
            default: {
                assert (false) : "literalType is null";
                break;
            }
        }
    }

    public IntegralLiteral rawValue(String raw) {
        int prefix;
        int radix;
        LiteralType newLT;
        if (raw == null) {
            this.rawValue = null;
            this.value = null;
            this.errorReasonForValue = "Missing value";
            this.markedAsLong = false;
            return this;
        }
        this.rawValue = raw;
        this.value = null;
        this.errorReasonForValue = null;
        this.markedAsLong = false;
        String v = raw.trim();
        if (v.startsWith("-")) {
            this.errorReasonForValue = NEGATIVE_NUMBERS_NOT_POSSIBLE;
            return this;
        }
        boolean markedAsLong = v.endsWith("L") || v.endsWith("l");
        String string = v = markedAsLong ? raw.substring(0, raw.length() - 1) : raw;
        if (v.startsWith("0x")) {
            newLT = LiteralType.HEXADECIMAL;
            radix = 16;
            prefix = 2;
        } else if (v.startsWith("0") && v.length() > 1) {
            newLT = LiteralType.OCTAL;
            radix = 8;
            prefix = 1;
        } else {
            newLT = LiteralType.DECIMAL;
            radix = 10;
            prefix = 0;
        }
        long v1 = 0L;
        BigInteger v2 = null;
        try {
            v1 = Long.parseLong(v.substring(prefix), radix);
        }
        catch (NumberFormatException e) {
            try {
                v2 = new BigInteger(v.substring(prefix), radix);
            }
            catch (NumberFormatException e2) {
                this.value = null;
                this.errorReasonForValue = "Not a valid integral literal: " + v;
                return this;
            }
        }
        Object result = IntegralLiteral.setRawValue0(markedAsLong, v1, v2);
        if (result instanceof Long) {
            this.markedAsLong = markedAsLong;
            this.literalType = newLT;
            this.value = (Long)result;
        } else {
            this.errorReasonForValue = (String)result + v;
        }
        return this;
    }

    private static Object setRawValue0(boolean markedAsLong, long v1, BigInteger v2) {
        if (v2 == null) {
            return v1;
        }
        if (!markedAsLong) {
            return "Int Literal above maximum value: ";
        }
        if (v2.compareTo(MAX_UNSIGNED_LONG) <= 0) {
            return v2.longValue();
        }
        return "Long literal too large: ";
    }

    public long astLongValue() throws AstException {
        return this.value == null ? 0L : this.value;
    }

    public int astIntValue() throws AstException {
        return this.value == null ? 0 : this.value.intValue();
    }

    @Override
    public String rawValue() {
        return this.rawValue;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (!visitor.visitIntegralLiteral(this)) {
            visitor.endVisit(this);
        }
        visitor.afterVisitIntegralLiteral(this);
    }
}

