/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import lombok.ast.Node;

public class ResolutionException
extends RuntimeException {
    private final Node problemNode;
    private final String message;

    public ResolutionException(Node problemNode, String message) {
        super(message);
        this.message = message;
        this.problemNode = problemNode;
    }

    @Override
    public String toString() {
        if (this.problemNode == null && this.getMessage() == null) {
            return "ResolutionException (unknown cause)";
        }
        if (this.problemNode == null) {
            return "AstException: " + this.getMessage();
        }
        String nodeDescription = this.problemNode == null ? "(null)" : this.problemNode.getClass().getName() + "(toString failed)";
        try {
            nodeDescription = ((Object)this.problemNode).toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.getMessage() == null) {
            return "ResolutionException at " + nodeDescription;
        }
        return String.format("ResolutionException: %s (at %s)", this.getMessage(), nodeDescription);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolutionException)) {
            return false;
        }
        ResolutionException other = (ResolutionException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.problemNode == null ? other.problemNode != null : !this.problemNode.equals(other.problemNode)) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }

    public boolean canEqual(Object other) {
        return other instanceof ResolutionException;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + (this.problemNode == null ? 0 : this.problemNode.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }
}

