/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.syntaxChecks;

import com.google.common.collect.Maps;
import java.util.Map;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Message;
import lombok.ast.Node;
import lombok.ast.syntaxChecks.MessageKey;

public class SyntacticValidityVisitorBase
extends ForwardingAstVisitor {
    final Map<Class<?>, Object> checkerObjectStore = Maps.newHashMap();
    final boolean recursing;

    SyntacticValidityVisitorBase(boolean recursing) {
        this.recursing = recursing;
    }

    <T> T getCheckerObject(Class<T> clazz) {
        Object o = this.checkerObjectStore.get(clazz);
        if (o != null) {
            return (T)o;
        }
        try {
            o = clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Class " + clazz.getName() + " could not be constructed. Does it have a public no-args constructort?", e);
        }
        this.checkerObjectStore.put(clazz, o);
        return (T)o;
    }

    void checkChildValidity(Node node, Node child, String name, boolean mandatory, Class<?> typeAssertion) {
        SyntacticValidityVisitorBase.verifyNodeRelation(node, child, name, mandatory, typeAssertion);
    }

    public static boolean verifyNodeRelation(Node parent, Node child, String name, boolean mandatory, Class<?> typeAssertion) {
        String typeAssertionName = typeAssertion.getSimpleName().toLowerCase();
        boolean typeAssertionVowel = SyntacticValidityVisitorBase.startsWithVowel(typeAssertionName);
        if (child == null) {
            if (mandatory) {
                parent.addMessage(Message.error(MessageKey.NODE_MISSING_MANDATORY_CHILD, String.format("Missing %s %s", name, typeAssertion.getSimpleName().toLowerCase())));
                return false;
            }
        } else if (!typeAssertion.isInstance(child)) {
            String actualName = child.getClass().getSimpleName();
            child.addMessage(Message.error(MessageKey.NODE_CHILD_TYPE_INCORRECT, String.format("%s isn't a%s %s but a%s %s", name, typeAssertionVowel ? "n" : "", typeAssertionName, SyntacticValidityVisitorBase.startsWithVowel(actualName) ? "n" : "", actualName)));
            return false;
        }
        return true;
    }

    private static boolean startsWithVowel(String typeAssertionName) {
        boolean typeAssertionVowel = typeAssertionName.isEmpty();
        if (!typeAssertionVowel) {
            char c = typeAssertionName.charAt(0);
            typeAssertionVowel = c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
        }
        return typeAssertionVowel;
    }

    @Override
    public boolean visitParseArtefact(Node node) {
        StringBuilder errorName = new StringBuilder();
        boolean first = true;
        for (char c : node.getClass().getSimpleName().toCharArray()) {
            if (first) {
                errorName.append(c);
                first = false;
                continue;
            }
            if (Character.isUpperCase(c)) {
                errorName.append(" ").append(Character.toLowerCase(c));
                continue;
            }
            errorName.append(c);
        }
        node.addMessage(Message.error(MessageKey.PARSEARTEFACT, "parse artefact remained in node tree"));
        return !this.recursing;
    }
}

