/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;

public class WinProcessManager {
    private static final Logger LOG = Logger.getInstance(WinProcessManager.class);

    private WinProcessManager() {
    }

    public static int getProcessPid(Process process) {
        if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
            try {
                long handle = ReflectionUtil.getField(process.getClass(), process, Long.TYPE, "handle");
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE winHandle = new WinNT.HANDLE();
                winHandle.setPointer(Pointer.createConstant((long)handle));
                return kernel.GetProcessId(winHandle);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalStateException("Unknown Process implementation");
    }

    public static boolean kill(Process process, boolean tree) {
        return WinProcessManager.kill(-1, process, tree);
    }

    public static boolean kill(int pid, boolean tree) {
        return WinProcessManager.kill(pid, null, tree);
    }

    private static boolean kill(int pid, Process process, boolean tree) {
        LOG.assertTrue(pid > 0 || process != null);
        try {
            if (process != null) {
                pid = WinProcessManager.getProcessPid(process);
            }
            String[] cmdArray = new String[]{"taskkill", "/f", "/pid", String.valueOf(pid), tree ? "/t" : ""};
            if (LOG.isDebugEnabled()) {
                LOG.debug(StringUtil.join(cmdArray, " "));
            }
            Process p = new ProcessBuilder(cmdArray).redirectErrorStream(true).start();
            String output = FileUtil.loadTextAndClose(p.getInputStream());
            int res = p.waitFor();
            if (res != 0 && (process == null || WinProcessManager.isAlive(process))) {
                LOG.warn(StringUtil.join(cmdArray, " ") + " failed: " + output);
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(output);
            }
            return true;
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    private static boolean isAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }
}

