/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBIterator<E>
implements Iterator<E> {
    private static final Object NONE = new String("#none");
    private static final Object STOP = new String("#stop");
    private static final Object SKIP = new String("#skip");
    private Object myCurrent = NONE;
    private Object myNext = NONE;
    private final Op myFirstOp = new Op<Object>(null);
    private Op myLastOp = this.myFirstOp;
    private static final Condition<JBIterator<?>> ADVANCE = new Condition<JBIterator<?>>(){

        @Override
        public boolean value(JBIterator<?> it) {
            return it.advance();
        }
    };

    @NotNull
    public static <E extends JBIterator<?>> JBIterable<E> cursor(@NotNull E iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/JBIterator", "cursor"));
        }
        JBIterable<JBIterator<?>> jBIterable = JBIterable.generate(iterator, Functions.identity()).takeWhile(ADVANCE);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "cursor"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterator<E> from(final @NotNull Iterator<E> it) {
        if (it == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "com/intellij/util/containers/JBIterator", "from"));
        }
        JBIterator<E> jBIterator = it instanceof JBIterator ? (JBIterator<E>)it : new JBIterator<E>(){

            @Override
            protected E nextImpl() {
                return it.hasNext() ? it.next() : this.stop();
            }
        };
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "from"));
        }
        return jBIterator;
    }

    protected abstract E nextImpl();

    protected void currentChanged() {
    }

    @Nullable
    protected final E stop() {
        this.myNext = STOP;
        return null;
    }

    @Nullable
    protected final E skip() {
        this.myNext = SKIP;
        return null;
    }

    @Override
    public final boolean hasNext() {
        this.peekNext();
        return this.myNext != STOP;
    }

    @Override
    @Nullable
    public final E next() {
        this.advance();
        return this.current();
    }

    public final boolean advance() {
        this.myCurrent = NONE;
        this.peekNext();
        if (this.myNext == STOP) {
            return false;
        }
        this.myCurrent = this.myNext;
        this.myNext = NONE;
        this.currentChanged();
        return true;
    }

    @Nullable
    public final E current() {
        if (this.myCurrent == NONE) {
            throw new NoSuchElementException();
        }
        return (E)this.myCurrent;
    }

    private void peekNext() {
        if (this.myNext != NONE) {
            return;
        }
        Object o = NONE;
        Op op = this.myFirstOp;
        while (op != null) {
            Object object = o = op == this.myFirstOp ? this.nextImpl() : op.apply(o);
            if (this.myNext == SKIP) {
                o = this.myNext = NONE;
                op = null;
            }
            if (this.myNext == STOP) {
                return;
            }
            op = op == null ? this.myFirstOp : op.nextOp;
        }
        this.myNext = o;
    }

    @NotNull
    public final <T> JBIterator<T> transform(@NotNull Function<? super E, T> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/util/containers/JBIterator", "transform"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(new Op<Function<? super E, T>>(function){

            @Override
            public Object apply(Object o) {
                return ((Function)this.impl).fun(o);
            }
        });
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "transform"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> filter(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/JBIterator", "filter"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(new Op<Condition<? super E>>(condition){

            @Override
            public Object apply(Object o) {
                return ((Condition)this.impl).value(o) ? o : JBIterator.this.skip();
            }
        });
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "filter"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> take(int count) {
        JBIterator jBIterator = this.takeWhile(new CountDown(count));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "take"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> takeWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/JBIterator", "takeWhile"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(new Op<Condition<? super E>>(condition){

            @Override
            public Object apply(Object o) {
                return ((Condition)this.impl).value(o) ? o : JBIterator.this.stop();
            }

            @Override
            public String toString() {
                return "takeWhile:" + super.toString();
            }
        });
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "takeWhile"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> skip(int count) {
        JBIterator jBIterator = this.skipWhile(new CountDown(count));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "skip"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> skipWhile(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/JBIterator", "skipWhile"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(new Op<Condition<? super E>>(condition){
            boolean active;
            {
                super(impl);
                this.active = true;
            }

            @Override
            public Object apply(Object o) {
                if (this.active && condition.value(o)) {
                    return JBIterator.this.skip();
                }
                this.active = false;
                return o;
            }

            @Override
            public String toString() {
                return "skipWhile:" + super.toString();
            }
        });
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "skipWhile"));
        }
        return jBIterator;
    }

    @NotNull
    private <T> T addOp(@NotNull Op op) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/util/containers/JBIterator", "addOp"));
        }
        this.myLastOp = this.myLastOp.nextOp = op;
        JBIterator jBIterator = this;
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "addOp"));
        }
        return (T)jBIterator;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public final List<E> toList() {
        List list = Collections.unmodifiableList(ContainerUtil.newArrayList(JBIterable.once(this)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "toList"));
        }
        return list;
    }

    public String toString() {
        JBIterable<Op> ops = this.operationsImpl();
        return "{cur=" + this.myCurrent + "; next=" + this.myNext + (ops.isEmpty() ? "" : "; ops[" + ops.size() + "]=" + ops) + "}";
    }

    @NotNull
    public final JBIterable<Function<Object, Object>> getTransformations() {
        JBIterable<Function<Object, Object>> jBIterable = this.operationsImpl().transform(new Function<Op, Object>(){

            @Override
            public Object fun(Op op) {
                return op.impl;
            }
        }).filter(Function.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "getTransformations"));
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<Op> operationsImpl() {
        JBIterable<Op> jBIterable = JBIterable.generate(this.myFirstOp.nextOp, new Function<Op, Op>(){

            @Override
            public Op fun(Op op) {
                return op.nextOp;
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "operationsImpl"));
        }
        return jBIterable;
    }

    static String toShortString(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/containers/JBIterator", "toShortString"));
        }
        String fqn = o.getClass().getName();
        return StringUtil.replace(o.toString(), fqn, StringUtil.getShortName(fqn, '.'));
    }

    private static class CountDown<A>
    implements Condition<A> {
        int cur;

        public CountDown(int count) {
            this.cur = count;
        }

        @Override
        public boolean value(A a) {
            return this.cur > 0 && this.cur-- != 0;
        }
    }

    private static class Op<T> {
        final T impl;
        Op nextOp;

        public Op(T impl) {
            this.impl = impl;
        }

        Object apply(Object o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.impl == null ? "" : JBIterator.toShortString(this.impl);
        }
    }
}

