/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.util.JpsPathUtil;

public class KotlinSourceFileCollector {
    @NotNull
    public static MultiMap<ModuleBuildTarget, File> getDirtySourceFiles(DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder) throws IOException {
        final MultiMap result = new MultiMap();
        dirtyFilesHolder.processDirtyFiles((FileProcessor)new FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget>(){

            public boolean apply(ModuleBuildTarget target, File file, JavaSourceRootDescriptor root) throws IOException {
                if (!root.getTarget().equals((Object)target)) {
                    return true;
                }
                if (KotlinSourceFileCollector.isKotlinSourceFile(file)) {
                    result.putValue((Object)target, (Object)file);
                }
                return true;
            }
        });
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/KotlinSourceFileCollector", "getDirtySourceFiles"));
        }
        return multiMap;
    }

    @NotNull
    public static List<File> getRemovedKotlinFiles(@NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleBuildTarget target) throws IOException {
        if (dirtyFilesHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirtyFilesHolder", "org/jetbrains/kotlin/jps/build/KotlinSourceFileCollector", "getRemovedKotlinFiles"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/KotlinSourceFileCollector", "getRemovedKotlinFiles"));
        }
        List list = ContainerUtil.map((Collection)ContainerUtil.filter((Collection)dirtyFilesHolder.getRemovedFiles((BuildTarget)target), (Condition)new Condition<String>(){

            public boolean value(String s) {
                return FileUtilRt.extensionEquals((String)s, (String)"kt");
            }
        }), (Function)new Function<String, File>(){

            public File fun(String s) {
                return new File(s);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/KotlinSourceFileCollector", "getRemovedKotlinFiles"));
        }
        return list;
    }

    @NotNull
    public static List<File> getAllKotlinSourceFiles(@NotNull ModuleBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/KotlinSourceFileCollector", "getAllKotlinSourceFiles"));
        }
        final List moduleExcludes = ContainerUtil.map((Collection)target.getModule().getExcludeRootsList().getUrls(), (Function)new Function<String, File>(){

            public File fun(String url) {
                return JpsPathUtil.urlToFile((String)url);
            }
        });
        final JpsCompilerExcludes compilerExcludes = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(target.getModule().getProject()).getCompilerExcludes();
        final ArrayList result = ContainerUtil.newArrayList();
        for (JpsModuleSourceRoot sourceRoot : KotlinSourceFileCollector.getRelevantSourceRoots(target)) {
            FileUtil.processFilesRecursively((File)sourceRoot.getFile(), (Processor)new Processor<File>(){

                public boolean process(File file) {
                    if (compilerExcludes.isExcluded(file)) {
                        return true;
                    }
                    if (file.isFile() && KotlinSourceFileCollector.isKotlinSourceFile(file)) {
                        result.add(file);
                    }
                    return true;
                }
            }, (Processor)new Processor<File>(){

                public boolean process(final File dir) {
                    return ContainerUtil.find((Iterable)moduleExcludes, (Condition)new Condition<File>(){

                        public boolean value(File exclude) {
                            return FileUtil.filesEqual((File)exclude, (File)dir);
                        }
                    }) == null;
                }
            });
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/KotlinSourceFileCollector", "getAllKotlinSourceFiles"));
        }
        return arrayList;
    }

    private static Iterable<JpsModuleSourceRoot> getRelevantSourceRoots(ModuleBuildTarget target) {
        JavaSourceRootType sourceRootType = target.isTests() ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        return target.getModule().getSourceRoots((JpsModuleSourceRootType)sourceRootType);
    }

    static boolean isKotlinSourceFile(File file) {
        return FileUtilRt.extensionEquals((String)file.getName(), (String)"kt");
    }

    private KotlinSourceFileCollector() {
    }
}

