/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.Deserialization;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationContext;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedType;
import org.jetbrains.kotlin.serialization.deserialization.FindClassInModuleKt;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeCapabilitiesDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.LocalClassResolver;
import org.jetbrains.kotlin.serialization.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.TypeBasedStarProjectionImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\tH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u00102\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010(\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0013\u001a$\u0012 \u0012\u001e\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00100\u00100\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;", "", "c", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationContext;", "parent", "typeParameterProtos", "", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$TypeParameter;", "debugName", "", "(Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationContext;Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;Ljava/util/List;Ljava/lang/String;)V", "classDescriptors", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "ownTypeParameters", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getOwnTypeParameters", "()Ljava/util/List;", "typeParameterDescriptors", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "", "kotlin.jvm.PlatformType", "computeClassDescriptor", "fqNameIndex", "toString", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type;", "additionalAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "typeArgument", "Lorg/jetbrains/kotlin/types/TypeProjection;", "parameter", "typeArgumentProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type$Argument;", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "typeParameterTypeConstructor", "typeParameterId", "deserialization"})
public final class TypeDeserializer {
    private final Function1<Integer, ClassDescriptor> classDescriptors;
    private final NotNullLazyValue<Map<Integer, TypeParameterDescriptor>> typeParameterDescriptors;
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final List<ProtoBuf.TypeParameter> typeParameterProtos;
    private final String debugName;

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return CollectionsKt.toReadOnlyList(((Map)this.typeParameterDescriptors.invoke()).values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)additionalAnnotations, (String)"additionalAnnotations");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            FlexibleTypeCapabilitiesDeserializer flexibleTypeCapabilitiesDeserializer = this.c.getComponents().getFlexibleTypeCapabilitiesDeserializer();
            String string = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
            FlexibleTypeCapabilities flexibleTypeCapabilities = flexibleTypeCapabilitiesDeserializer.capabilitiesById(string);
            if (flexibleTypeCapabilities == null) {
                KotlinType kotlinType = ErrorUtils.createErrorType((String)((Object)((Object)new DeserializedType(this.c, proto, null, 4, null)) + ": Capabilities not found for id " + id));
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"ErrorUtils.createErrorTy\u2026es not found for id $id\")");
                return kotlinType;
            }
            FlexibleTypeCapabilities capabilities = flexibleTypeCapabilities;
            KotlinType kotlinType = (KotlinType)new DeserializedType(this.c, proto, null, 4, null);
            ProtoBuf.Type type = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            if (type == null) {
                Intrinsics.throwNpe();
            }
            return DelegatingFlexibleType.Companion.create(kotlinType, (KotlinType)new DeserializedType(this.c, type, null, 4, null), capabilities);
        }
        return (KotlinType)new DeserializedType(this.c, proto, additionalAnnotations);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType type$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type, Annotations annotations2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: type");
        }
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.type(type, annotations2);
    }

    @NotNull
    public final TypeConstructor typeConstructor(@NotNull ProtoBuf.Type proto) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        if (proto.hasClassName()) {
            classDescriptor = (ClassDescriptor)this.classDescriptors.invoke((Object)proto.getClassName());
            if (classDescriptor == null || (classDescriptor = classDescriptor.getTypeConstructor()) == null) {
                classDescriptor = this.c.getComponents().getNotFoundClasses().get(proto, this.c.getNameResolver(), this.c.getTypeTable());
            }
        } else if (proto.hasTypeParameter()) {
            classDescriptor = this.typeParameterTypeConstructor(proto.getTypeParameter());
            if (classDescriptor == null) {
                TypeConstructor typeConstructor = ErrorUtils.createErrorType((String)("Unknown type parameter " + proto.getTypeParameter())).getConstructor();
                classDescriptor = typeConstructor;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor, (String)"ErrorUtils.createErrorTy\u2026eParameter}\").constructor");
            }
        } else if (proto.hasTypeParameterName()) {
            TypeParameterDescriptor parameter;
            Object v5;
            String name;
            DeclarationDescriptor container;
            block14: {
                List list;
                container = this.c.getContainingDeclaration();
                DeclarationDescriptor declarationDescriptor = container;
                if (declarationDescriptor instanceof ClassDescriptor) {
                    List list2 = ((ClassDescriptor)container).getTypeConstructor().getParameters();
                    list = list2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"container.typeConstructor.parameters");
                } else if (declarationDescriptor instanceof CallableDescriptor) {
                    List list3 = ((CallableDescriptor)container).getTypeParameters();
                    list = list3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"container.typeParameters");
                } else {
                    list = kotlin.collections.CollectionsKt.emptyList();
                }
                List typeParameters = list;
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                Iterable iterable = typeParameters;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)name)) continue;
                    v5 = t;
                    break block14;
                }
                v5 = null;
            }
            if ((classDescriptor = (parameter = (TypeParameterDescriptor)v5)) == null || (classDescriptor = classDescriptor.getTypeConstructor()) == null) {
                TypeConstructor typeConstructor = ErrorUtils.createErrorType((String)("Deserialized type parameter " + name + " in " + container)).getConstructor();
                classDescriptor = typeConstructor;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor, (String)"ErrorUtils.createErrorTy\u2026 $container\").constructor");
            }
        } else {
            TypeConstructor typeConstructor = ErrorUtils.createErrorType((String)"Unknown type").getConstructor();
            classDescriptor = typeConstructor;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor, (String)"ErrorUtils.createErrorTy\u2026nknown type\").constructor");
        }
        return classDescriptor;
    }

    private final TypeConstructor typeParameterTypeConstructor(int typeParameterId) {
        Object object = (TypeParameterDescriptor)((Map)this.typeParameterDescriptors.invoke()).get(typeParameterId);
        if (object == null || (object = object.getTypeConstructor()) == null) {
            TypeDeserializer typeDeserializer = this.parent;
            object = typeDeserializer != null ? typeDeserializer.typeParameterTypeConstructor(typeParameterId) : null;
        }
        return object;
    }

    private final ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId id = this.c.getNameResolver().getClassId(fqNameIndex);
        if (id.isLocal()) {
            LocalClassResolver localClassResolver = this.c.getComponents().getLocalClassResolver();
            ClassId classId = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
            return localClassResolver.resolveLocalClass(classId);
        }
        ModuleDescriptor moduleDescriptor = this.c.getComponents().getModuleDescriptor();
        ClassId classId = id;
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
    }

    @NotNull
    public final TypeProjection typeArgument(@Nullable TypeParameterDescriptor parameter, @NotNull ProtoBuf.Type.Argument typeArgumentProto) {
        Intrinsics.checkParameterIsNotNull((Object)typeArgumentProto, (String)"typeArgumentProto");
        if (Intrinsics.areEqual((Object)((Object)typeArgumentProto.getProjection()), (Object)((Object)ProtoBuf.Type.Argument.Projection.STAR))) {
            TypeProjection typeProjection;
            if (parameter == null) {
                KotlinType kotlinType = this.c.getComponents().getModuleDescriptor().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"c.components.moduleDescr\u2026.builtIns.nullableAnyType");
                typeProjection = (TypeProjection)new TypeBasedStarProjectionImpl(kotlinType);
            } else {
                typeProjection = (TypeProjection)new StarProjectionImpl(parameter);
            }
            return typeProjection;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)projection), (String)"typeArgumentProto.projection");
        Variance variance = Deserialization.variance(projection);
        ProtoBuf.Type type = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type == null) {
            return (TypeProjection)new TypeProjectionImpl(ErrorUtils.createErrorType((String)"No type recorded"));
        }
        ProtoBuf.Type type2 = type;
        return (TypeProjection)new TypeProjectionImpl(variance, TypeDeserializer.type$default(this, type2, null, 2, null));
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, (String)"typeParameterProtos");
        Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
        this.c = c;
        this.parent = parent;
        this.typeParameterProtos = typeParameterProtos;
        this.debugName = debugName;
        this.classDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        this.typeParameterDescriptors = this.c.getStorageManager().createLazyValue((Function0)new Function0<Map<Integer, ? extends TypeParameterDescriptor>>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @NotNull
            public final Map<Integer, TypeParameterDescriptor> invoke() {
                Map map;
                if (TypeDeserializer.access$getTypeParameterProtos$p(this.this$0).isEmpty()) {
                    map = MapsKt.emptyMap();
                } else {
                    LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
                    for (IndexedValue indexedValue : kotlin.collections.CollectionsKt.withIndex((Iterable)TypeDeserializer.access$getTypeParameterProtos$p(this.this$0))) {
                        int index = indexedValue.component1();
                        ProtoBuf.TypeParameter proto = (ProtoBuf.TypeParameter)indexedValue.component2();
                        Map map2 = result;
                        Integer n = proto.getId();
                        DeserializedTypeParameterDescriptor deserializedTypeParameterDescriptor = new DeserializedTypeParameterDescriptor(TypeDeserializer.access$getC$p(this.this$0), proto, index);
                        map2.put(n, deserializedTypeParameterDescriptor);
                    }
                    map = result;
                }
                return map;
            }
            {
                this.this$0 = typeDeserializer;
                super(0);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$computeClassDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassDescriptor(fqNameIndex);
    }

    @NotNull
    public static final /* synthetic */ List access$getTypeParameterProtos$p(TypeDeserializer $this) {
        return $this.typeParameterProtos;
    }

    @NotNull
    public static final /* synthetic */ DeserializationContext access$getC$p(TypeDeserializer $this) {
        return $this.c;
    }
}

