/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.OptionId;
import com.intellij.application.options.OptionsApplicabilityFilter;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.DataManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class CodeCompletionPanel {
    JPanel myPanel;
    private JCheckBox myCbAutocompletion;
    private JCheckBox myCbAutopopupJavaDoc;
    private JTextField myAutopopupJavaDocField;
    private JCheckBox myCbOnCodeCompletion;
    private JCheckBox myCbOnSmartTypeCompletion;
    private JCheckBox myCbParameterInfoPopup;
    private JTextField myParameterInfoDelayField;
    private JCheckBox myCbShowFullParameterSignatures;
    private JComboBox myCaseSensitiveCombo;
    private JCheckBox myCbSorting;
    private JBCheckBox myCbSelectByChars;
    private static final String CASE_SENSITIVE_ALL = ApplicationBundle.message((String)"combobox.autocomplete.case.sensitive.all", (Object[])new Object[0]);
    private static final String CASE_SENSITIVE_NONE = ApplicationBundle.message((String)"combobox.autocomplete.case.sensitive.none", (Object[])new Object[0]);
    private static final String CASE_SENSITIVE_FIRST_LETTER = ApplicationBundle.message((String)"combobox.autocomplete.case.sensitive.first.letter", (Object[])new Object[0]);
    private static final String[] CASE_VARIANTS = new String[]{CASE_SENSITIVE_ALL, CASE_SENSITIVE_NONE, CASE_SENSITIVE_FIRST_LETTER};

    public CodeCompletionPanel() {
        this.$$$setupUI$$$();
        this.myCaseSensitiveCombo.setModel(new DefaultComboBoxModel<String>(CASE_VARIANTS));
        ActionManager actionManager = ActionManager.getInstance();
        String basicShortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)actionManager.getAction("CodeCompletion"));
        String smartShortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)actionManager.getAction("SmartTypeCompletion"));
        if (StringUtil.isNotEmpty((String)basicShortcut)) {
            this.myCbOnCodeCompletion.setText(this.myCbOnCodeCompletion.getText() + " ( " + basicShortcut + " )");
        }
        if (StringUtil.isNotEmpty((String)smartShortcut)) {
            this.myCbOnSmartTypeCompletion.setText(this.myCbOnSmartTypeCompletion.getText() + " ( " + smartShortcut + " )");
        }
        this.myCbAutocompletion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/CodeCompletionPanel$1", "actionPerformed"));
                }
                boolean selected = CodeCompletionPanel.this.myCbAutocompletion.isSelected();
                CodeCompletionPanel.this.myCbSelectByChars.setEnabled(selected);
            }
        });
        this.myCbAutopopupJavaDoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/CodeCompletionPanel$2", "actionPerformed"));
                }
                CodeCompletionPanel.this.myAutopopupJavaDocField.setEnabled(CodeCompletionPanel.this.myCbAutopopupJavaDoc.isSelected());
            }
        });
        this.myCbParameterInfoPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/CodeCompletionPanel$3", "actionPerformed"));
                }
                CodeCompletionPanel.this.myParameterInfoDelayField.setEnabled(CodeCompletionPanel.this.myCbParameterInfoPopup.isSelected());
            }
        });
        CodeCompletionPanel.hideOption(this.myCbOnSmartTypeCompletion, OptionId.COMPLETION_SMART_TYPE);
        this.reset();
    }

    private static void hideOption(JComponent component, OptionId id) {
        component.setVisible(OptionsApplicabilityFilter.isApplicable(id));
    }

    public void reset() {
        String value;
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        switch (codeInsightSettings.COMPLETION_CASE_SENSITIVE) {
            case 1: {
                value = CASE_SENSITIVE_ALL;
                break;
            }
            case 2: {
                value = CASE_SENSITIVE_NONE;
                break;
            }
            default: {
                value = CASE_SENSITIVE_FIRST_LETTER;
            }
        }
        this.myCaseSensitiveCombo.setSelectedItem(value);
        this.myCbSelectByChars.setSelected(codeInsightSettings.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS);
        this.myCbOnCodeCompletion.setSelected(codeInsightSettings.AUTOCOMPLETE_ON_CODE_COMPLETION);
        this.myCbOnSmartTypeCompletion.setSelected(codeInsightSettings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION);
        this.myCbAutocompletion.setSelected(codeInsightSettings.AUTO_POPUP_COMPLETION_LOOKUP);
        this.myCbAutopopupJavaDoc.setSelected(codeInsightSettings.AUTO_POPUP_JAVADOC_INFO);
        this.myAutopopupJavaDocField.setEnabled(codeInsightSettings.AUTO_POPUP_JAVADOC_INFO);
        this.myAutopopupJavaDocField.setText(String.valueOf(codeInsightSettings.JAVADOC_INFO_DELAY));
        this.myCbParameterInfoPopup.setSelected(codeInsightSettings.AUTO_POPUP_PARAMETER_INFO);
        this.myParameterInfoDelayField.setEnabled(codeInsightSettings.AUTO_POPUP_PARAMETER_INFO);
        this.myParameterInfoDelayField.setText(String.valueOf(codeInsightSettings.PARAMETER_INFO_DELAY));
        this.myCbShowFullParameterSignatures.setSelected(codeInsightSettings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO);
        this.myCbAutocompletion.setSelected(codeInsightSettings.AUTO_POPUP_COMPLETION_LOOKUP);
        this.myCbSorting.setSelected(UISettings.getInstance().SORT_LOOKUP_ELEMENTS_LEXICOGRAPHICALLY);
        this.myCbAutocompletion.setText("Autopopup code completion" + (PowerSaveMode.isEnabled() ? " (not available in Power Save mode)" : ""));
    }

    public void apply() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        codeInsightSettings.COMPLETION_CASE_SENSITIVE = this.getCaseSensitiveValue();
        codeInsightSettings.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS = this.myCbSelectByChars.isSelected();
        codeInsightSettings.AUTOCOMPLETE_ON_CODE_COMPLETION = this.myCbOnCodeCompletion.isSelected();
        codeInsightSettings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION = this.myCbOnSmartTypeCompletion.isSelected();
        codeInsightSettings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO = this.myCbShowFullParameterSignatures.isSelected();
        codeInsightSettings.AUTO_POPUP_PARAMETER_INFO = this.myCbParameterInfoPopup.isSelected();
        codeInsightSettings.AUTO_POPUP_COMPLETION_LOOKUP = this.myCbAutocompletion.isSelected();
        codeInsightSettings.AUTO_POPUP_JAVADOC_INFO = this.myCbAutopopupJavaDoc.isSelected();
        codeInsightSettings.PARAMETER_INFO_DELAY = CodeCompletionPanel.getIntegerValue(this.myParameterInfoDelayField.getText(), 0);
        codeInsightSettings.JAVADOC_INFO_DELAY = CodeCompletionPanel.getIntegerValue(this.myAutopopupJavaDocField.getText(), 0);
        UISettings.getInstance().SORT_LOOKUP_ELEMENTS_LEXICOGRAPHICALLY = this.myCbSorting.isSelected();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myPanel));
        if (project2 != null) {
            DaemonCodeAnalyzer.getInstance((Project)project2).settingsChanged();
        }
    }

    public boolean isModified() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        boolean isModified = false;
        isModified |= this.getCaseSensitiveValue() != codeInsightSettings.COMPLETION_CASE_SENSITIVE;
        isModified |= CodeCompletionPanel.isModified(this.myCbOnCodeCompletion, codeInsightSettings.AUTOCOMPLETE_ON_CODE_COMPLETION);
        isModified |= CodeCompletionPanel.isModified((JCheckBox)this.myCbSelectByChars, codeInsightSettings.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS);
        isModified |= CodeCompletionPanel.isModified(this.myCbOnSmartTypeCompletion, codeInsightSettings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION);
        isModified |= CodeCompletionPanel.isModified(this.myCbShowFullParameterSignatures, codeInsightSettings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO);
        isModified |= CodeCompletionPanel.isModified(this.myCbParameterInfoPopup, codeInsightSettings.AUTO_POPUP_PARAMETER_INFO);
        isModified |= CodeCompletionPanel.isModified(this.myCbAutocompletion, codeInsightSettings.AUTO_POPUP_COMPLETION_LOOKUP);
        isModified |= CodeCompletionPanel.isModified(this.myCbAutopopupJavaDoc, codeInsightSettings.AUTO_POPUP_JAVADOC_INFO);
        isModified |= CodeCompletionPanel.isModified(this.myParameterInfoDelayField, codeInsightSettings.PARAMETER_INFO_DELAY, 0);
        isModified |= CodeCompletionPanel.isModified(this.myAutopopupJavaDocField, codeInsightSettings.JAVADOC_INFO_DELAY, 0);
        return isModified |= CodeCompletionPanel.isModified(this.myCbSorting, UISettings.getInstance().SORT_LOOKUP_ELEMENTS_LEXICOGRAPHICALLY);
    }

    private static boolean isModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static boolean isModified(JTextField textField, int value, int defaultValue) {
        return CodeCompletionPanel.getIntegerValue(textField.getText(), defaultValue) != value;
    }

    private static int getIntegerValue(String s, int defaultValue) {
        int value = StringUtilRt.parseInt((String)s, (int)defaultValue);
        return value < 0 ? defaultValue : value;
    }

    private int getCaseSensitiveValue() {
        Object value = this.myCaseSensitiveCombo.getSelectedItem();
        if (CASE_SENSITIVE_ALL.equals(value)) {
            return 1;
        }
        if (CASE_SENSITIVE_NONE.equals(value)) {
            return 2;
        }
        return 3;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox3;
        JTextField jTextField2;
        JCheckBox jCheckBox4;
        JComboBox jComboBox;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("html.disable", Boolean.FALSE);
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.code.completion"), (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.case.sensitive.completion"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbOnCodeCompletion = jCheckBox7 = new JCheckBox();
        jCheckBox7.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.autocomplete.basic"));
        jPanel3.add((Component)jCheckBox7, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myCbOnSmartTypeCompletion = jCheckBox6 = new JCheckBox();
        jCheckBox6.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.autocomplete.smart.type"));
        jPanel3.add((Component)jCheckBox6, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myCbSorting = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(2, 2, 2, 2));
        jCheckBox5.setText("Sort lookup items lexicographically");
        jPanel3.add((Component)jCheckBox5, new GridConstraints(4, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myCaseSensitiveCombo = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.autocomplete.when.only.one.choice"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myCbAutocompletion = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(2, 2, 2, 2));
        jCheckBox4.setText("Autopopup code completion");
        jPanel3.add((Component)jCheckBox4, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAutopopupJavaDocField = jTextField2 = new JTextField();
        jTextField2.setColumns(4);
        jTextField2.setText("1000");
        jPanel3.add((Component)jTextField2, new GridConstraints(8, 1, 1, 1, 9, 0, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbAutopopupJavaDoc = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.autopopup.javadoc.in.ms"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setEnabled(true);
        jBLabel.setText("For explicitly invoked completion");
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jPanel4.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null, 2));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(7, 0, 1, 1, 0, 3, 0, 0, new Dimension(-1, 4), null, null));
        this.myCbSelectByChars = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Insert selected variant by typing dot, space, etc.");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.parameter.info"), (int)0, (int)0, null, null));
        this.myCbParameterInfoPopup = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.autopopup.in.ms"));
        jPanel6.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbShowFullParameterSignatures = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.full.signatures"));
        jPanel6.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myParameterInfoDelayField = jTextField = new JTextField();
        jTextField.setColumns(4);
        jTextField.setText("1000");
        jPanel6.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, new Dimension(50, -1), null, new Dimension(50, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

