/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.action;

import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.arrangement.Rearranger;

public class RearrangeCodeAction
extends AnAction {
    public void update(AnActionEvent e) {
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        boolean enabled = file2 != null && Rearranger.EXTENSION.forLanguage(file2.getLanguage()) != null;
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document2 = editor.getDocument();
        documentManager.commitDocument(document2);
        PsiFile file2 = documentManager.getPsiFile(document2);
        if (file2 == null) {
            return;
        }
        SelectionModel model = editor.getSelectionModel();
        if (model.hasSelection()) {
            new RearrangeCodeProcessor(file2, model).run();
        } else {
            new RearrangeCodeProcessor(file2).run();
        }
    }
}

