/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SeverityUtil {
    @NotNull
    public static Collection<SeverityRegistrar.SeverityBasedTextAttributes> getRegisteredHighlightingInfoTypes(@NotNull SeverityRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInsight/daemon/impl/SeverityUtil", "getRegisteredHighlightingInfoTypes"));
        }
        Collection<SeverityRegistrar.SeverityBasedTextAttributes> collection = registrar.allRegisteredAttributes();
        for (HighlightInfoType type : registrar.standardSeverities()) {
            collection.add(SeverityUtil.getSeverityBasedTextAttributes(registrar, type));
        }
        Collection<SeverityRegistrar.SeverityBasedTextAttributes> collection2 = collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityUtil", "getRegisteredHighlightingInfoTypes"));
        }
        return collection2;
    }

    private static SeverityRegistrar.SeverityBasedTextAttributes getSeverityBasedTextAttributes(@NotNull SeverityRegistrar registrar, @NotNull HighlightInfoType type) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInsight/daemon/impl/SeverityUtil", "getSeverityBasedTextAttributes"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/SeverityUtil", "getSeverityBasedTextAttributes"));
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes textAttributes = scheme.getAttributes(type.getAttributesKey());
        if (textAttributes != null) {
            return new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes, (HighlightInfoType.HighlightInfoTypeImpl)type);
        }
        TextAttributes severity = registrar.getTextAttributesBySeverity(type.getSeverity(null));
        return new SeverityRegistrar.SeverityBasedTextAttributes(severity, (HighlightInfoType.HighlightInfoTypeImpl)type);
    }
}

