/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToThrowsFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddExceptionFromFieldInitializerToConstructorThrowsFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(AddExceptionFromFieldInitializerToConstructorThrowsFix.class);
    private final PsiElement myWrongElement;

    public AddExceptionFromFieldInitializerToConstructorThrowsFix(PsiElement element) {
        this.myWrongElement = element;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionFromFieldInitializerToConstructorThrowsFix", "isAvailable"));
        }
        if (!this.myWrongElement.isValid()) {
            return false;
        }
        NavigatablePsiElement maybeField = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, (Class[])new Class[]{PsiMethod.class, PsiFunctionalExpression.class, PsiField.class});
        if (!(maybeField instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)maybeField;
        if (field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null || containingClass instanceof PsiAnonymousClass || containingClass.isInterface() || !containingClass.isWritable()) {
            return false;
        }
        List<PsiClassType> exceptions = ExceptionUtil.getUnhandledExceptions((PsiElement)field);
        if (exceptions.isEmpty()) {
            return false;
        }
        PsiMethod[] existedConstructors = containingClass.getConstructors();
        this.setText(QuickFixBundle.message("add.exception.from.field.initializer.to.constructor.throws.text", existedConstructors.length));
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiClass aClass;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionFromFieldInitializerToConstructorThrowsFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        NavigatablePsiElement field = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, (Class[])new Class[]{PsiMethod.class, PsiFunctionalExpression.class, PsiField.class});
        if (field instanceof PsiField && (aClass = ((PsiField)field).getContainingClass()) != null) {
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                AddDefaultConstructorFix defaultConstructorFix = new AddDefaultConstructorFix(aClass);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionFromFieldInitializerToConstructorThrowsFix", "lambda$invoke$0"));
                    }
                    defaultConstructorFix.invoke(project2, null, file2);
                });
                constructors = aClass.getConstructors();
                LOG.assertTrue(constructors.length != 0);
            }
            THashSet unhandledExceptions = new THashSet(ExceptionUtil.getUnhandledExceptions((PsiElement)field));
            for (PsiMethod constructor : constructors) {
                AddExceptionToThrowsFix.addExceptionsToThrowsList(project2, constructor, (Set<PsiClassType>)unhandledExceptions);
            }
        }
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.exception.from.field.initializer.to.constructor.throws.family.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionFromFieldInitializerToConstructorThrowsFix", "getFamilyName"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

