/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddVariableInitializerFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddReturnFix");
    private final PsiVariable myVariable;

    public AddVariableInitializerFix(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "<init>"));
        }
        this.myVariable = variable;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"quickfix.add.variable.text", (Object[])new Object[]{this.myVariable.getName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"quickfix.add.variable.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "isAvailable"));
        }
        return this.myVariable.isValid() && this.myVariable.getManager().isInProject((PsiElement)this.myVariable) && !this.myVariable.hasInitializer() && !(this.myVariable instanceof PsiParameter);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myVariable.getContainingFile())) {
            return;
        }
        LookupElement[] suggestedInitializers = AddVariableInitializerFix.suggestInitializer(this.myVariable);
        LOG.assertTrue(suggestedInitializers.length > 0);
        LOG.assertTrue(suggestedInitializers[0] instanceof ExpressionLookupItem);
        PsiExpression initializer = (PsiExpression)suggestedInitializers[0].getObject();
        if (this.myVariable instanceof PsiLocalVariable) {
            ((PsiLocalVariable)this.myVariable).setInitializer(initializer);
        } else if (this.myVariable instanceof PsiField) {
            ((PsiField)this.myVariable).setInitializer(initializer);
        } else {
            LOG.error("Unknown variable type: " + this.myVariable);
        }
        AddVariableInitializerFix.runAssignmentTemplate(Collections.singletonList(this.myVariable.getInitializer()), suggestedInitializers, editor);
    }

    public static void runAssignmentTemplate(@NotNull List<PsiExpression> initializers, final @NotNull LookupElement[] suggestedInitializers, @Nullable Editor editor) {
        if (initializers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializers", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "runAssignmentTemplate"));
        }
        if (suggestedInitializers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedInitializers", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "runAssignmentTemplate"));
        }
        if (editor == null) {
            return;
        }
        LOG.assertTrue(!initializers.isEmpty());
        PsiExpression initializer = (PsiExpression)ContainerUtil.getFirstItem(initializers);
        PsiExpression context = initializers.size() == 1 ? initializer : PsiTreeUtil.findCommonParent(initializers);
        PsiDocumentManager.getInstance((Project)initializer.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)context);
        for (PsiExpression e : initializers) {
            builder.replaceElement((PsiElement)e, new Expression(){

                @Nullable
                public Result calculateResult(ExpressionContext context1) {
                    return this.calculateQuickResult(context1);
                }

                @Nullable
                public Result calculateQuickResult(ExpressionContext context1) {
                    return new PsiElementResult(suggestedInitializers[0].getPsiElement());
                }

                @Nullable
                public LookupElement[] calculateLookupItems(ExpressionContext context1) {
                    return suggestedInitializers;
                }
            });
        }
        builder.run(editor, false);
    }

    @NotNull
    public static LookupElement[] suggestInitializer(PsiVariable variable) {
        PsiClass aClass;
        PsiType type = variable.getType();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
        SmartList result2 = new SmartList();
        String defaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)type);
        ExpressionLookupItem defaultExpression = new ExpressionLookupItem(elementFactory.createExpressionFromText(defaultValue, (PsiElement)variable));
        result2.add(defaultExpression);
        if (type instanceof PsiClassType && (aClass = PsiTypesUtil.getPsiClass((PsiType)type)) != null && PsiUtil.hasDefaultConstructor((PsiClass)aClass)) {
            String expressionText = "new " + type.getCanonicalText(false) + "()";
            ExpressionLookupItem newExpression = new ExpressionLookupItem(elementFactory.createExpressionFromText(expressionText, (PsiElement)variable));
            result2.add(newExpression);
        }
        LookupElement[] lookupElementArray = result2.toArray(new LookupElement[result2.size()]);
        if (lookupElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "suggestInitializer"));
        }
        return lookupElementArray;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

