/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MethodThrowsFix
extends LocalQuickFixOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix");
    private final String myThrowsCanonicalText;
    private final boolean myShouldThrow;
    private final String myMethodName;

    public MethodThrowsFix(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, boolean shouldThrow, boolean showContainingClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix", "<init>"));
        }
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix", "<init>"));
        }
        super((PsiElement)method);
        this.myThrowsCanonicalText = exceptionType.getCanonicalText();
        this.myShouldThrow = shouldThrow;
        this.myMethodName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)(1 | (showContainingClass ? 4096 : 0)), (int)0);
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message(this.myShouldThrow ? "fix.throws.list.add.exception" : "fix.throws.list.remove.exception", this.myThrowsCanonicalText, this.myMethodName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.throws.list.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix", "isAvailable"));
        }
        PsiMethod myMethod = (PsiMethod)startElement;
        return myMethod.isValid() && myMethod.getManager().isInProject((PsiElement)myMethod);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix", "invoke"));
        }
        PsiMethod myMethod = (PsiMethod)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(myMethod.getContainingFile())) {
            return;
        }
        PsiJavaCodeReferenceElement[] referenceElements = myMethod.getThrowsList().getReferenceElements();
        try {
            boolean alreadyThrows = false;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
                if (!referenceElement.getCanonicalText().equals(this.myThrowsCanonicalText)) continue;
                alreadyThrows = true;
                if (this.myShouldThrow) continue;
                referenceElement.delete();
                break;
            }
            if (this.myShouldThrow && !alreadyThrows) {
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)myMethod.getProject()).getElementFactory();
                PsiClassType type = (PsiClassType)factory.createTypeFromText(this.myThrowsCanonicalText, (PsiElement)myMethod);
                PsiJavaCodeReferenceElement ref = factory.createReferenceElementByType(type);
                ref = (PsiJavaCodeReferenceElement)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)ref);
                myMethod.getThrowsList().add((PsiElement)ref);
            }
            UndoUtil.markPsiFileForUndo((PsiFile)file2);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

