/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodFix;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

abstract class StaticMembersProcessor<T extends PsiMember & PsiDocCommentOwner>
implements Processor<T> {
    private final MultiMap<PsiClass, T> mySuggestions = new LinkedMultiMap();
    private final Map<PsiClass, Boolean> myPossibleClasses = new HashMap<PsiClass, Boolean>();
    private final PsiElement myPlace;
    private PsiType myExpectedType;

    protected StaticMembersProcessor(PsiElement place) {
        this.myPlace = place;
        this.myExpectedType = PsiType.NULL;
    }

    protected abstract boolean isApplicable(T var1, PsiElement var2);

    @NotNull
    public List<T> getMembersToImport(boolean applicableOnly) {
        ArrayList list = new ArrayList();
        ArrayList applicableList = new ArrayList();
        for (Map.Entry methodEntry : this.mySuggestions.entrySet()) {
            this.registerMember((PsiClass)methodEntry.getKey(), (Collection)methodEntry.getValue(), list, applicableList);
        }
        ArrayList result2 = !applicableOnly && applicableList.isEmpty() ? list : applicableList;
        for (int i = result2.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiMember method = (PsiMember)result2.get(i);
            if (!StaticImportMethodFix.isExcluded(method)) continue;
            result2.remove(i);
        }
        Collections.sort(result2, CodeInsightUtil.createSortIdenticalNamedMembersComparator(this.myPlace));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticMembersProcessor", "getMembersToImport"));
        }
        return arrayList;
    }

    public PsiType getExpectedType() {
        if (this.myExpectedType == PsiType.NULL) {
            this.myExpectedType = this.getExpectedTypeInternal();
        }
        return this.myExpectedType;
    }

    private PsiType getExpectedTypeInternal() {
        if (this.myPlace == null) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)this.myPlace.getParent());
        if (parent instanceof PsiVariable) {
            if (this.myPlace.equals(PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiVariable)parent).getInitializer()))) {
                return ((PsiVariable)parent).getType();
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            if (this.myPlace.equals(PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)parent).getRExpression()))) {
                return ((PsiAssignmentExpression)parent).getLExpression().getType();
            }
        } else if (parent instanceof PsiReturnStatement) {
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class});
            if (psiElement instanceof PsiLambdaExpression) {
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)((PsiLambdaExpression)psiElement).getFunctionalInterfaceType());
            }
            if (psiElement instanceof PsiMethod) {
                return ((PsiMethod)psiElement).getReturnType();
            }
        } else if (parent instanceof PsiExpressionList) {
            JavaResolveResult resolveResult;
            PsiElement psiElement;
            PsiElement pParent = parent.getParent();
            if (pParent instanceof PsiCallExpression && parent.equals(((PsiCallExpression)pParent).getArgumentList()) && (psiElement = (resolveResult = ((PsiCallExpression)pParent).resolveMethodGenerics()).getElement()) instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)psiElement;
                PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                int idx = ArrayUtilRt.find((Object[])((PsiExpressionList)parent).getExpressions(), (Object)PsiUtil.skipParenthesizedExprUp((PsiElement)this.myPlace));
                if (idx > -1 && parameters.length > 0) {
                    PsiParameter lastParameter;
                    PsiType parameterType = parameters[Math.min(idx, parameters.length - 1)].getType();
                    if (idx >= parameters.length - 1 && (lastParameter = parameters[parameters.length - 1]).isVarArgs()) {
                        parameterType = ((PsiEllipsisType)lastParameter.getType()).getComponentType();
                    }
                    return resolveResult.getSubstitutor().substitute(parameterType);
                }
                return null;
            }
        } else if (parent instanceof PsiLambdaExpression) {
            return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)((PsiLambdaExpression)parent).getFunctionalInterfaceType());
        }
        return null;
    }

    public boolean process(T member) {
        ProgressManager.checkCanceled();
        if (JavaCompletionUtil.isInExcludedPackage(member, false) || !member.hasModifierProperty("static")) {
            return true;
        }
        PsiFile file2 = member.getContainingFile();
        PsiClass containingClass = member.getContainingClass();
        if (file2 instanceof PsiJavaFile && !((PsiJavaFile)file2).getPackageName().isEmpty()) {
            this.mySuggestions.putValue((Object)containingClass, member);
        }
        return this.processCondition();
    }

    private boolean processCondition() {
        return this.mySuggestions.size() < 50;
    }

    private void registerMember(PsiClass containingClass, Collection<T> members, List<T> list, List<T> applicableList) {
        Boolean alreadyMentioned = this.myPossibleClasses.get(containingClass);
        if (alreadyMentioned == Boolean.TRUE) {
            return;
        }
        if (containingClass.getQualifiedName() == null) {
            return;
        }
        if (alreadyMentioned == null) {
            if (!members.isEmpty()) {
                list.add(members.iterator().next());
            }
            this.myPossibleClasses.put(containingClass, false);
        }
        for (PsiMember member : members) {
            if (!PsiUtil.isAccessible((Project)this.myPlace.getProject(), (PsiMember)member, (PsiElement)this.myPlace, (PsiClass)containingClass) || !this.isApplicable(member, this.myPlace)) continue;
            applicableList.add(member);
            this.myPossibleClasses.put(containingClass, true);
            break;
        }
    }
}

