/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterBetweenBracesHandler
extends EnterHandlerDelegateAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesHandler");

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesHandler", "preprocessEnter"));
        }
        Document document2 = editor.getDocument();
        CharSequence text = document2.getCharsSequence();
        int caretOffset = (Integer)caretOffsetRef.get();
        if (!CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int prevCharOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)(caretOffset - 1), (String)" \t");
        int nextCharOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)" \t");
        if (!(EnterBetweenBracesHandler.isValidOffset(prevCharOffset, text) && EnterBetweenBracesHandler.isValidOffset(nextCharOffset, text) && this.isBracePair(text.charAt(prevCharOffset), text.charAt(nextCharOffset)))) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        if (file2.findElementAt(prevCharOffset) == file2.findElementAt(nextCharOffset)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int line = document2.getLineNumber(caretOffset);
        int start = document2.getLineStartOffset(line);
        CodeDocumentationUtil.CommentContext commentContext = CodeDocumentationUtil.tryParseCommentContext(file2, text, caretOffset, start);
        String indentInsideJavadoc = commentContext.docAsterisk ? CodeDocumentationUtil.getIndentInsideJavadoc(document2, caretOffset) : null;
        originalHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        Project project2 = editor.getProject();
        if (indentInsideJavadoc != null && project2 != null && CodeStyleSettingsManager.getSettings((Project)project2).JD_LEADING_ASTERISKS_ARE_ENABLED) {
            document2.insertString(editor.getCaretModel().getOffset(), (CharSequence)("*" + indentInsideJavadoc));
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document2);
        try {
            CodeStyleManager.getInstance((Project)file2.getProject()).adjustLineIndent(file2, editor.getCaretModel().getOffset());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return indentInsideJavadoc == null ? EnterHandlerDelegate.Result.Continue : EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    private static boolean isValidOffset(int offset, CharSequence text) {
        return offset >= 0 && offset < text.length();
    }

    protected boolean isBracePair(char c1, char c2) {
        return c1 == '(' && c2 == ')' || c1 == '{' && c2 == '}';
    }
}

