/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;

public class LiteralFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof PsiJavaToken) {
            if (((PsiJavaToken)psiElement).getTokenType() == JavaTokenType.STRING_LITERAL && !StringUtil.endsWithChar((CharSequence)psiElement.getText(), (char)'\"')) {
                editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"\"");
            } else if (((PsiJavaToken)psiElement).getTokenType() == JavaTokenType.CHARACTER_LITERAL && !StringUtil.endsWithChar((CharSequence)psiElement.getText(), (char)'\'')) {
                editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"'");
            }
        }
    }
}

