/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.AbstractElementSignatureProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementSignatureProvider
extends AbstractElementSignatureProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.XmlElementSignatureProvider");

    @Override
    public String getSignature(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/folding/impl/XmlElementSignatureProvider", "getSignature"));
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            PsiElement parent = tag.getParent();
            StringBuilder buffer = new StringBuilder();
            buffer.append("tag").append("#");
            String name = tag.getName();
            buffer.append(name.length() == 0 ? "<unnamed>" : XmlElementSignatureProvider.escape(name));
            buffer.append("#");
            buffer.append(XmlElementSignatureProvider.getChildIndex(tag, parent, name, XmlTag.class));
            if (!(parent instanceof PsiFile)) {
                String parentSignature = this.getSignature(parent);
                if (parentSignature == null) {
                    return null;
                }
                buffer.append(";");
                buffer.append(parentSignature);
            }
            return buffer.toString();
        }
        return null;
    }

    @Override
    protected PsiElement restoreBySignatureTokens(@NotNull PsiFile file2, @NotNull PsiElement parent, @NotNull String type, @NotNull StringTokenizer tokenizer, @Nullable StringBuilder processingInfoStorage) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/XmlElementSignatureProvider", "restoreBySignatureTokens"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/codeInsight/folding/impl/XmlElementSignatureProvider", "restoreBySignatureTokens"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/folding/impl/XmlElementSignatureProvider", "restoreBySignatureTokens"));
        }
        if (tokenizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenizer", "com/intellij/codeInsight/folding/impl/XmlElementSignatureProvider", "restoreBySignatureTokens"));
        }
        if (type.equals("tag")) {
            String name = tokenizer.nextToken();
            if (parent instanceof XmlFile && (parent = ((XmlFile)parent).getDocument()) == null) {
                return null;
            }
            try {
                int index = Integer.parseInt(tokenizer.nextToken());
                String unescapedName = XmlElementSignatureProvider.unescape(name);
                XmlTag result2 = XmlElementSignatureProvider.restoreElementInternal(parent, unescapedName, index, XmlTag.class);
                if (result2 == null && file2.getFileType() == StdFileTypes.JSP) {
                    if (parent instanceof XmlDocument) {
                        result2 = XmlElementSignatureProvider.restoreElementInternal((PsiElement)HtmlUtil.getRealXmlDocument((XmlDocument)parent), unescapedName, index, XmlTag.class);
                    } else if (name.equals("<unnamed>") && parent != null) {
                        result2 = XmlElementSignatureProvider.restoreElementInternal(parent, "", index, XmlTag.class);
                    }
                }
                return result2;
            }
            catch (NumberFormatException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return null;
    }
}

