/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

class JavaWithIfElseSurrounder
extends JavaStatementsSurrounder {
    JavaWithIfElseSurrounder() {
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.ifelse.template", (Object[])new Object[0]);
    }

    @Override
    public TextRange surroundStatements(Project project2, Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = PsiManager.getInstance((Project)project2);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        if ((statements = SurroundWithUtil.moveDeclarationsOut(container, statements, false)).length == 0) {
            return null;
        }
        String text = "if(a){\n}else{\n}";
        PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(text, null);
        ifStatement = (PsiIfStatement)codeStyleManager.reformat((PsiElement)ifStatement);
        PsiStatement thenBranch = (ifStatement = (PsiIfStatement)container.addAfter((PsiElement)ifStatement, statements[statements.length - 1])).getThenBranch();
        if (!(thenBranch instanceof PsiBlockStatement)) {
            return null;
        }
        PsiCodeBlock thenBlock = ((PsiBlockStatement)thenBranch).getCodeBlock();
        SurroundWithUtil.indentCommentIfNecessary(thenBlock, statements);
        thenBlock.addRange(statements[0], statements[statements.length - 1]);
        container.deleteChildRange(statements[0], statements[statements.length - 1]);
        ifStatement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(ifStatement);
        PsiExpression condition = ifStatement.getCondition();
        if (condition == null) {
            return null;
        }
        TextRange range = condition.getTextRange();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        return new TextRange(range.getStartOffset(), range.getStartOffset());
    }
}

