/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.generation.surroundWith.SurroundWithRangeAdjuster;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlFile;

public class XmlSurroundWithRangeAdjuster
implements SurroundWithRangeAdjuster {
    private static boolean isLanguageWithWSSignificant(Language lang) {
        return lang == StdLanguages.HTML || lang == StdLanguages.XHTML || lang == StdLanguages.JSP || lang == StdLanguages.JSPX;
    }

    private static Language getLanguage(PsiElement element) {
        Language lang = element.getLanguage();
        if (lang == StdLanguages.XML) {
            PsiElement parent = element.getParent();
            lang = parent.getLanguage();
        }
        return lang;
    }

    public TextRange adjustSurroundWithRange(PsiFile file2, TextRange selectedRange) {
        if (!(file2 instanceof XmlFile)) {
            return selectedRange;
        }
        int startOffset = selectedRange.getStartOffset();
        int endOffset = selectedRange.getEndOffset();
        PsiElement element1 = file2.findElementAt(startOffset);
        PsiElement element2 = file2.findElementAt(endOffset - 1);
        Language lang1 = XmlSurroundWithRangeAdjuster.getLanguage(element1);
        Language lang2 = XmlSurroundWithRangeAdjuster.getLanguage(element2);
        if (element1 instanceof PsiWhiteSpace && XmlSurroundWithRangeAdjuster.isLanguageWithWSSignificant(lang1)) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file2.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace && XmlSurroundWithRangeAdjuster.isLanguageWithWSSignificant(lang2)) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file2.findElementAt(endOffset);
        }
        if ((lang1 = XmlSurroundWithRangeAdjuster.getLanguage(element1)) != (lang2 = XmlSurroundWithRangeAdjuster.getLanguage(element2))) {
            return null;
        }
        TextRange.assertProperRange((int)startOffset, (int)endOffset, (Object)("Wrong offsets for " + selectedRange.substring(file2.getText())));
        return new TextRange(startOffset, endOffset);
    }
}

