/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class HtmlClosingTagErrorFilter
extends HighlightErrorFilter {
    public HtmlClosingTagErrorFilter(XmlHighlightVisitor xmlHighlightVisitor) {
        assert (xmlHighlightVisitor != null);
    }

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/highlighting/HtmlClosingTagErrorFilter", "shouldHighlightErrorElement"));
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || psiFile.getViewProvider().getBaseLanguage() != HTMLLanguage.INSTANCE && HTMLLanguage.INSTANCE != element.getLanguage()) {
            return true;
        }
        PsiElement[] children2 = element.getChildren();
        return children2.length <= 0 || !(children2[0] instanceof XmlToken) || XmlTokenType.XML_END_TAG_START != ((XmlToken)children2[0]).getTokenType() || !XmlErrorMessages.message("xml.parsing.closing.tag.matches.nothing", new Object[0]).equals(element.getErrorDescription());
    }
}

