/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertCompareToToEqualsIntention
extends BaseElementAtCaretIntentionAction {
    public static final String TEXT = "Convert '.compareTo()' method to '.equals()' (may change semantics)";

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            return;
        }
        ResolveResult resolveResult = ConvertCompareToToEqualsIntention.findCompareTo(element);
        assert (resolveResult != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        Pair<PsiExpression, PsiExpression> qualifierAndParameter = ConvertCompareToToEqualsIntention.getQualifierAndParameter(resolveResult.getCompareToCall());
        PsiExpression newExpression = elementFactory.createExpressionFromText(String.format((resolveResult.isEqEq() ? "" : "!") + "%s.equals(%s)", ((PsiExpression)qualifierAndParameter.getFirst()).getText(), ((PsiExpression)qualifierAndParameter.getSecond()).getText()), null);
        PsiElement result2 = resolveResult.getBinaryExpression().replace((PsiElement)newExpression);
        editor.getCaretModel().moveToOffset(result2.getTextOffset() + result2.getTextLength());
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "isAvailable"));
        }
        return ConvertCompareToToEqualsIntention.findCompareTo(element) != null;
    }

    private static Pair<PsiExpression, PsiExpression> getQualifierAndParameter(PsiMethodCallExpression methodCallExpression) {
        PsiExpression qualifier = methodCallExpression.getMethodExpression().getQualifierExpression();
        assert (qualifier != null);
        PsiExpression parameter = methodCallExpression.getArgumentList().getExpressions()[0];
        return Pair.create((Object)qualifier, (Object)parameter);
    }

    @Nullable
    private static ResolveResult findCompareTo(PsiElement element) {
        boolean isEqEq;
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiBinaryExpression.class);
        if (binaryExpression == null) {
            return null;
        }
        PsiJavaToken operationSign = binaryExpression.getOperationSign();
        if (JavaTokenType.NE.equals(operationSign.getTokenType())) {
            isEqEq = false;
        } else if (JavaTokenType.EQEQ.equals(operationSign.getTokenType())) {
            isEqEq = true;
        } else {
            return null;
        }
        PsiMethodCallExpression compareToExpression = null;
        boolean hasZero = false;
        for (PsiExpression psiExpression : binaryExpression.getOperands()) {
            if (compareToExpression == null && ConvertCompareToToEqualsIntention.detectCompareTo(psiExpression)) {
                compareToExpression = (PsiMethodCallExpression)psiExpression;
                continue;
            }
            if (hasZero || !ConvertCompareToToEqualsIntention.detectZero(psiExpression)) continue;
            hasZero = true;
        }
        if (!hasZero || compareToExpression == null) {
            return null;
        }
        ConvertCompareToToEqualsIntention.getQualifierAndParameter(compareToExpression);
        return new ResolveResult(binaryExpression, compareToExpression, isEqEq);
    }

    private static boolean detectCompareTo(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "detectCompareTo"));
        }
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        if (methodCallExpression.getMethodExpression().getQualifierExpression() == null) {
            return false;
        }
        PsiMethod psiMethod = methodCallExpression.resolveMethod();
        if (psiMethod == null || !"compareTo".equals(psiMethod.getName()) || psiMethod.getParameterList().getParametersCount() != 1) {
            return false;
        }
        if (methodCallExpression.getArgumentList().getExpressions().length != 1) {
            return false;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiClass javaLangComparable = JavaPsiFacade.getInstance((Project)expression.getProject()).findClass("java.lang.Comparable", GlobalSearchScope.allScope((Project)expression.getProject()));
        if (javaLangComparable == null) {
            return false;
        }
        return containingClass.isInheritor(javaLangComparable, true);
    }

    private static boolean detectZero(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "detectZero"));
        }
        if (!(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        Object value = ((PsiLiteralExpression)expression).getValue();
        return Comparing.equal((Object)value, (Object)0);
    }

    @NotNull
    public String getFamilyName() {
        if (TEXT == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "getFamilyName"));
        }
        return TEXT;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "getText"));
        }
        return string;
    }

    private static class ResolveResult {
        private final PsiBinaryExpression myBinaryExpression;
        private final PsiMethodCallExpression myCompareToCall;
        private final boolean myEqEq;

        private ResolveResult(PsiBinaryExpression binaryExpression, PsiMethodCallExpression compareToCall, boolean eqEq) {
            this.myBinaryExpression = binaryExpression;
            this.myCompareToCall = compareToCall;
            this.myEqEq = eqEq;
        }

        public PsiBinaryExpression getBinaryExpression() {
            return this.myBinaryExpression;
        }

        public PsiMethodCallExpression getCompareToCall() {
            return this.myCompareToCall;
        }

        public boolean isEqEq() {
            return this.myEqEq;
        }
    }
}

