/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import javax.swing.JList;

public class ImplementAbstractMethodHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.ImplementAbstractMethodHandler");
    private final Project myProject;
    private final Editor myEditor;
    private final PsiMethod myMethod;
    private JList myList;

    public ImplementAbstractMethodHandler(Project project2, Editor editor, PsiMethod method) {
        this.myProject = project2;
        this.myEditor = editor;
        this.myMethod = method;
    }

    public void invoke() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        PsiElement[][] result2 = new PsiElement[1][];
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass psiClass = this.myMethod.getContainingClass();
            if (!psiClass.isValid()) {
                return;
            }
            if (!psiClass.isEnum()) {
                result2[0] = this.getClassImplementations(psiClass);
            } else {
                ArrayList<Object> enumConstants = new ArrayList<Object>();
                for (PsiField field : psiClass.getFields()) {
                    if (!(field instanceof PsiEnumConstant)) continue;
                    PsiEnumConstantInitializer initializingClass = ((PsiEnumConstant)field).getInitializingClass();
                    if (initializingClass != null) {
                        PsiMethod method = initializingClass.findMethodBySignature(this.myMethod, true);
                        if (method != null && method.getContainingClass().equals(initializingClass)) continue;
                        enumConstants.add(initializingClass);
                        continue;
                    }
                    enumConstants.add(field);
                }
                result2[0] = PsiUtilCore.toPsiElementArray(enumConstants);
            }
        }), CodeInsightBundle.message((String)"intention.implement.abstract.method.searching.for.descendants.progress", (Object[])new Object[0]), true, this.myProject);
        if (result2[0] == null) {
            return;
        }
        if (result2[0].length == 0) {
            Messages.showMessageDialog((Project)this.myProject, (String)CodeInsightBundle.message((String)"intention.implement.abstract.method.error.no.classes.message", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"intention.implement.abstract.method.error.no.classes.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            return;
        }
        if (result2[0].length == 1) {
            this.implementInClass(new Object[]{result2[0][0]});
            return;
        }
        MyPsiElementListCellRenderer elementListCellRenderer = new MyPsiElementListCellRenderer();
        elementListCellRenderer.sort(result2[0]);
        this.myList = new JBList(result2[0]);
        this.myList.setSelectionMode(2);
        Runnable runnable2 = () -> {
            int index = this.myList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.implementInClass(this.myList.getSelectedValues());
        };
        this.myList.setCellRenderer(elementListCellRenderer);
        PopupChooserBuilder builder = new PopupChooserBuilder(this.myList);
        elementListCellRenderer.installSpeedSearch(builder);
        builder.setTitle(CodeInsightBundle.message((String)"intention.implement.abstract.method.class.chooser.title", (Object[])new Object[0])).setItemChoosenCallback(runnable2).createPopup().showInBestPositionFor(this.myEditor);
    }

    public void implementInClass(Object[] selection) {
        for (Object o : selection) {
            if (((PsiElement)o).isValid()) continue;
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            LinkedHashSet<Object> classes = new LinkedHashSet<Object>();
            for (final Object o : selection) {
                if (o instanceof PsiEnumConstant) {
                    classes.add(ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiClass>(){

                        public PsiClass compute() {
                            return ((PsiEnumConstant)o).getOrCreateInitializingClass();
                        }
                    }));
                    continue;
                }
                classes.add((PsiClass)o);
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(classes)) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (PsiClass psiClass : classes) {
                    try {
                        OverrideImplementUtil.overrideOrImplement(psiClass, this.myMethod);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        }, CodeInsightBundle.message((String)"intention.implement.abstract.method.command.name", (Object[])new Object[0]), null);
    }

    private PsiClass[] getClassImplementations(PsiClass psiClass) {
        ArrayList<PsiClass> list = new ArrayList<PsiClass>();
        for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)psiClass)) {
            PsiSubstitutor classSubstitutor;
            PsiMethod method;
            if (inheritor.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)inheritor) || (method = (classSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)psiClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY)) != null ? MethodSignatureUtil.findMethodBySignature((PsiClass)inheritor, (MethodSignature)this.myMethod.getSignature(classSubstitutor), (boolean)true) : inheritor.findMethodBySignature(this.myMethod, true)) == null || !psiClass.equals(method.getContainingClass())) continue;
            list.add(inheritor);
        }
        return list.toArray(new PsiClass[list.size()]);
    }

    private static class MyPsiElementListCellRenderer
    extends PsiElementListCellRenderer<PsiElement> {
        private MyPsiElementListCellRenderer() {
        }

        void sort(PsiElement[] result2) {
            Comparator comparator2 = PsiClassListCellRenderer.INSTANCE.getComparator();
            Arrays.sort(result2, (o1, o2) -> {
                if (o1 instanceof PsiEnumConstant && o2 instanceof PsiEnumConstant) {
                    return ((PsiEnumConstant)o1).getName().compareTo(((PsiEnumConstant)o2).getName());
                }
                if (o1 instanceof PsiEnumConstant) {
                    return -1;
                }
                if (o2 instanceof PsiEnumConstant) {
                    return 1;
                }
                return comparator2.compare((PsiClass)o1, (PsiClass)o2);
            });
        }

        @Override
        public String getElementText(PsiElement element) {
            return element instanceof PsiClass ? PsiClassListCellRenderer.INSTANCE.getElementText((PsiClass)element) : ((PsiEnumConstant)element).getName();
        }

        @Override
        protected String getContainerText(PsiElement element, String name) {
            return element instanceof PsiClass ? PsiClassListCellRenderer.getContainerTextStatic(element) : ((PsiEnumConstant)element).getContainingClass().getQualifiedName();
        }

        @Override
        protected int getIconFlags() {
            return 0;
        }
    }
}

