/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiType;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DfaPsiType {
    private final PsiType myPsiType;
    private final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myAssignableCache;
    private final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myConvertibleCache;

    DfaPsiType(@NotNull PsiType psiType, Map<Pair<DfaPsiType, DfaPsiType>, Boolean> assignableCache, Map<Pair<DfaPsiType, DfaPsiType>, Boolean> convertibleCache) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/codeInspection/dataFlow/value/DfaPsiType", "<init>"));
        }
        this.myPsiType = psiType;
        this.myAssignableCache = assignableCache;
        this.myConvertibleCache = convertibleCache;
    }

    @NotNull
    public PsiType getPsiType() {
        PsiType psiType = this.myPsiType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaPsiType", "getPsiType"));
        }
        return psiType;
    }

    public boolean isAssignableFrom(DfaPsiType other) {
        if (other == this) {
            return true;
        }
        Pair key2 = Pair.create((Object)this, (Object)other);
        Boolean result2 = this.myAssignableCache.get(key2);
        if (result2 == null) {
            result2 = this.myPsiType.isAssignableFrom(other.myPsiType);
            this.myAssignableCache.put((Pair<DfaPsiType, DfaPsiType>)key2, result2);
        }
        return result2;
    }

    public boolean isConvertibleFrom(DfaPsiType other) {
        if (other == this) {
            return true;
        }
        Pair key2 = Pair.create((Object)this, (Object)other);
        Boolean result2 = this.myConvertibleCache.get(key2);
        if (result2 == null) {
            result2 = this.myPsiType.isConvertibleFrom(other.myPsiType);
            this.myConvertibleCache.put((Pair<DfaPsiType, DfaPsiType>)key2, result2);
        }
        return result2;
    }

    public String toString() {
        return this.myPsiType.getPresentableText();
    }
}

