/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class SequentialCleanupTask
implements SequentialTask {
    private static final Logger LOG = Logger.getInstance(SequentialCleanupTask.class);
    private final Project myProject;
    private final List<Pair<PsiFile, HighlightInfo>> myResults = new ArrayList<Pair<PsiFile, HighlightInfo>>();
    private final SequentialModalProgressTask myProgressTask;
    private int myCount = 0;

    public SequentialCleanupTask(Project project2, LinkedHashMap<PsiFile, List<HighlightInfo>> results, SequentialModalProgressTask task) {
        this.myProject = project2;
        for (Map.Entry<PsiFile, List<HighlightInfo>> entry : results.entrySet()) {
            PsiFile file2 = entry.getKey();
            List<HighlightInfo> infos = entry.getValue();
            Collections.sort(infos, (info1, info2) -> info2.getStartOffset() - info1.getStartOffset());
            for (HighlightInfo info : infos) {
                this.myResults.add((Pair<PsiFile, HighlightInfo>)Pair.create((Object)file2, (Object)info));
            }
        }
        this.myProgressTask = task;
    }

    public void prepare() {
    }

    public boolean isDone() {
        return this.myCount > this.myResults.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean iteration() {
        Pair<PsiFile, HighlightInfo> pair = this.myResults.get(this.myCount++);
        ProgressIndicator indicator = this.myProgressTask.getIndicator();
        if (indicator != null) {
            indicator.setFraction((double)this.myCount / (double)this.myResults.size());
            indicator.setText("Processing " + ((PsiFile)pair.first).getName());
        }
        for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> actionRange : ((HighlightInfo)pair.second).quickFixActionRanges) {
            AccessToken token = WriteAction.start();
            try {
                ((HighlightInfo.IntentionActionDescriptor)actionRange.getFirst()).getAction().invoke(this.myProject, null, (PsiFile)pair.first);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                token.finish();
            }
        }
        return true;
    }

    public void stop() {
    }
}

