/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.AddJavadocIntention;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspectionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocLocalInspection
extends JavaDocLocalInspectionBase {
    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Override
    protected LocalQuickFix createAddJavadocFix(@NotNull PsiElement nameIdentifier, boolean isOnTheFly) {
        if (nameIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameIdentifier", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection", "createAddJavadocFix"));
        }
        return isOnTheFly ? new AddJavadocFix(nameIdentifier) : null;
    }

    @Override
    protected LocalQuickFix createAddMissingTagFix(@NotNull String tag, @NotNull String value, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection", "createAddMissingTagFix"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection", "createAddMissingTagFix"));
        }
        return new AddMissingTagFix(tag, value);
    }

    @Override
    protected LocalQuickFix createAddMissingParamTagFix(@NotNull String name, boolean isOnTheFly) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection", "createAddMissingParamTagFix"));
        }
        return new AddMissingParamTagFix(name);
    }

    @Override
    protected LocalQuickFix createRegisterTagFix(@NotNull String tag, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection", "createRegisterTagFix"));
        }
        return new AddUnknownTagToCustoms(this, tag);
    }

    private static class AddUnknownTagToCustoms
    implements LocalQuickFix {
        private final JavaDocLocalInspectionBase myInspection;
        private final String myTag;

        public AddUnknownTagToCustoms(@NotNull JavaDocLocalInspectionBase inspection, @NotNull String tag) {
            if (inspection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspection", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms", "<init>"));
            }
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms", "<init>"));
            }
            this.myInspection = inspection;
            this.myTag = tag;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms", "applyFix"));
            }
            this.myInspection.registerAdditionalTag(this.myTag);
            InspectionProfile profile = InspectionProjectProfileManager.getInstance(project2).getInspectionProfile();
            InspectionProfileManager.getInstance().fireProfileChanged((Profile)profile);
        }

        @NotNull
        public String getName() {
            String string = QuickFixBundle.message("add.docTag.to.custom.tags", this.myTag);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("fix.javadoc.family", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms", "getFamilyName"));
            }
            return string;
        }
    }

    private static class AddMissingParamTagFix
    extends AddMissingTagFix {
        private final String myName;

        public AddMissingParamTagFix(String name) {
            super("param", name);
            this.myName = name;
        }

        @Override
        @Nullable
        protected PsiElement getAnchor(ProblemDescriptor descriptor) {
            PsiElement parent;
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element == null ? null : element.getParent();
            if (!(parent instanceof PsiDocComment)) {
                return null;
            }
            PsiDocComment docComment = (PsiDocComment)parent;
            PsiDocCommentOwner owner = docComment.getOwner();
            if (!(owner instanceof PsiMethod)) {
                return null;
            }
            Object[] parameters = ((PsiMethod)owner).getParameterList().getParameters();
            PsiParameter myParam = (PsiParameter)ContainerUtil.find((Object[])parameters, psiParameter -> this.myName.equals(psiParameter.getName()));
            if (myParam == null) {
                return null;
            }
            PsiDocTag[] tags = docComment.findTagsByName("param");
            if (tags.length == 0) {
                tags = docComment.getTags();
                if (tags.length == 0) {
                    return null;
                }
                return tags[0];
            }
            PsiParameter nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)myParam, PsiParameter.class);
            while (nextParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(nextParam, tag)) continue;
                    return tag;
                }
                nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextParam, PsiParameter.class);
            }
            PsiParameter prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)myParam, PsiParameter.class);
            while (prevParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(prevParam, tag)) continue;
                    return PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, PsiDocTag.class);
                }
                prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevParam, PsiParameter.class);
            }
            return null;
        }

        private static boolean matches(PsiParameter param, PsiDocTag tag) {
            PsiDocTagValue valueElement = tag.getValueElement();
            String name = param.getName();
            return valueElement != null && name != null && valueElement.getText().trim().startsWith(name);
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.param.tag", (Object[])new Object[]{this.myName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingParamTagFix", "getName"));
            }
            return string;
        }
    }

    private static class AddMissingTagFix
    implements LocalQuickFix {
        private final String myTag;
        private final String myValue;

        public AddMissingTagFix(@NotNull String tag, @NotNull String value) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix", "<init>"));
            }
            this.myTag = tag;
            this.myValue = value;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix", "applyFix"));
            }
            PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getEndElement(), PsiDocComment.class);
            if (docComment != null) {
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{docComment})) {
                    return;
                }
                PsiDocTag tag = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createDocTagFromText("@" + this.myTag + " " + this.myValue);
                PsiElement anchor = this.getAnchor(descriptor);
                PsiElement addedTag = anchor != null ? docComment.addBefore((PsiElement)tag, anchor) : docComment.add((PsiElement)tag);
                AddMissingTagFix.moveCaretAfter(addedTag);
            }
        }

        @Nullable
        protected PsiElement getAnchor(ProblemDescriptor descriptor) {
            return null;
        }

        private static void moveCaretAfter(PsiElement newCaretPosition) {
            PsiElement sibling = newCaretPosition.getNextSibling();
            if (sibling != null) {
                ((Navigatable)sibling).navigate(true);
            }
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.tag", (Object[])new Object[]{this.myTag, this.myValue});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.tag.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix", "getFamilyName"));
            }
            return string;
        }
    }

    private static class AddJavadocFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final AddJavadocIntention myIntention = new AddJavadocIntention();

        public AddJavadocFix(PsiElement nameIdentifier) {
            super(nameIdentifier);
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddJavadocFix", "invoke"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddJavadocFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddJavadocFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddJavadocFix", "invoke"));
            }
            this.myIntention.invoke(project2, editor, startElement);
        }

        @NotNull
        public String getText() {
            String string = this.myIntention.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddJavadocFix", "getText"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.myIntention.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddJavadocFix", "getFamilyName"));
            }
            return string;
        }
    }

    private class OptionsPanel
    extends JPanel {
        public OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.emptyInsets(), 0, 0);
            String title = InspectionsBundle.message((String)"inspection.javadoc.dialog.title", (Object[])new Object[0]);
            FieldPanel additionalTagsPanel = new FieldPanel(InspectionsBundle.message((String)"inspection.javadoc.label.text", (Object[])new Object[0]), title, null, null);
            additionalTagsPanel.setPreferredSize(new Dimension(150, additionalTagsPanel.getPreferredSize().height));
            additionalTagsPanel.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    Document document2 = e.getDocument();
                    try {
                        String text = document2.getText(0, document2.getLength());
                        if (text != null) {
                            JavaDocLocalInspection.this.myAdditionalJavadocTags = text.trim();
                        }
                    }
                    catch (BadLocationException ex) {
                        Logger.getInstance(JavaDocLocalInspection.class).error((Throwable)ex);
                    }
                }
            });
            additionalTagsPanel.setText(JavaDocLocalInspection.this.myAdditionalJavadocTags);
            this.add((Component)additionalTagsPanel, gc);
            JBTabbedPane tabs = new JBTabbedPane(3);
            String[] tags = new String[]{"@author", "@version", "@since"};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.package", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public"}, tags, JavaDocLocalInspection.this.PACKAGE_OPTIONS));
            tags = new String[]{"@author", "@version", "@since", "@param"};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "package"}, tags, JavaDocLocalInspection.this.TOP_LEVEL_CLASS_OPTIONS));
            tags = new String[]{"@return", "@param", InspectionsBundle.message((String)"inspection.javadoc.throws.or.exception.option", (Object[])new Object[0])};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.method", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "protected", "package", "private"}, tags, JavaDocLocalInspection.this.METHOD_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.field", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "protected", "package", "private"}, null, JavaDocLocalInspection.this.FIELD_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.inner.class", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "protected", "package", "private"}, null, JavaDocLocalInspection.this.INNER_CLASS_OPTIONS));
            this.add((Component)tabs, gc);
            JCheckBox checkBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.deprecated", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_DEPRECATED);
            checkBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_DEPRECATED = checkBox.isSelected();
            });
            gc.gridwidth = 1;
            this.add((Component)checkBox, gc);
            JCheckBox periodCheckBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.period", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD);
            periodCheckBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD = periodCheckBox.isSelected();
            });
            this.add((Component)periodCheckBox, gc);
            JCheckBox ignoreDuplicateThrowsCheckBox = new JCheckBox("Ignore duplicate throws tag", JavaDocLocalInspection.this.isIgnoreDuplicatedThrows());
            ignoreDuplicateThrowsCheckBox.addActionListener(e -> JavaDocLocalInspection.this.setIgnoreDuplicatedThrows(ignoreDuplicateThrowsCheckBox.isSelected()));
            this.add((Component)ignoreDuplicateThrowsCheckBox, gc);
            JCheckBox ignorePointToItselfCheckBox = new JCheckBox("Ignore javadoc pointing to itself", JavaDocLocalInspection.this.IGNORE_POINT_TO_ITSELF);
            ignorePointToItselfCheckBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_POINT_TO_ITSELF = ignorePointToItselfCheckBox.isSelected();
            });
            this.add((Component)ignorePointToItselfCheckBox, gc);
            JCheckBox ignoreSimpleAccessorsCheckBox = new JCheckBox("Ignore simple property accessors", JavaDocLocalInspection.this.isIgnoreSimpleAccessors());
            ignoreSimpleAccessorsCheckBox.addActionListener(e -> JavaDocLocalInspection.this.setIgnoreSimpleAccessors(ignoreSimpleAccessorsCheckBox.isSelected()));
            this.add((Component)ignoreSimpleAccessorsCheckBox, gc);
        }

        private JPanel createOptionsPanel(String[] modifiers, String[] tags, JavaDocLocalInspectionBase.Options options) {
            JPanel pane = new JPanel(new GridLayout(1, tags == null ? 1 : 2));
            pane.add(this.createScopePanel(modifiers, options));
            if (tags != null) {
                pane.add(this.createTagsPanel(tags, options));
            }
            pane.validate();
            return pane;
        }

        private JPanel createScopePanel(String[] modifiers, JavaDocLocalInspectionBase.Options options) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createCompoundBorder((Border)IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.scope.for.title", (Object[])new Object[0]), (boolean)true), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
            for (int i = 0; i < modifiers.length; ++i) {
                sliderLabels.put(i + 1, new JLabel(modifiers[i]));
            }
            JSlider slider = new JSlider(1, 1, modifiers.length, 1);
            slider.setLabelTable(sliderLabels);
            slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            slider.setPreferredSize((Dimension)JBUI.size((int)80, (int)50));
            slider.setPaintLabels(true);
            slider.setSnapToTicks(true);
            slider.addChangeListener(e -> {
                int value = slider.getValue();
                options.ACCESS_JAVADOC_REQUIRED_FOR = modifiers[value - 1];
                for (Integer key2 : sliderLabels.keySet()) {
                    ((JComponent)sliderLabels.get(key2)).setForeground((Color)(key2 <= value ? JBColor.BLACK : Gray._100));
                }
            });
            JBColor fore = JBColor.BLACK;
            for (int i = 0; i < modifiers.length; ++i) {
                ((JComponent)sliderLabels.get(i + 1)).setForeground((Color)fore);
                if (!modifiers[i].equals(options.ACCESS_JAVADOC_REQUIRED_FOR)) continue;
                slider.setValue(i + 1);
                fore = Gray._100;
            }
            panel.add((Component)slider, "West");
            return panel;
        }

        private JPanel createTagsPanel(String[] tags, JavaDocLocalInspectionBase.Options options) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createCompoundBorder((Border)IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.javadoc.required.tags.option.title", (Object[])new Object[0]), (boolean)true), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            GridBagConstraints gc = new GridBagConstraints();
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.fill = 2;
            gc.anchor = 18;
            for (int i = 0; i < tags.length; ++i) {
                JCheckBox box = new JCheckBox(tags[i]);
                gc.gridy = i;
                if (i == tags.length - 1) {
                    gc.weighty = 1.0;
                }
                panel.add((Component)box, gc);
                box.setSelected(JavaDocLocalInspectionBase.isTagRequired(options, tags[i]));
                box.addChangeListener(new MyChangeListener(box, options, tags[i]));
            }
            return panel;
        }

        private class MyChangeListener
        implements ChangeListener {
            private final JCheckBox myCheckBox;
            private final JavaDocLocalInspectionBase.Options myOptions;
            private final String myTagName;

            public MyChangeListener(JCheckBox checkBox, JavaDocLocalInspectionBase.Options options, String tagName) {
                this.myCheckBox = checkBox;
                this.myOptions = options;
                this.myTagName = tagName;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.myCheckBox.isSelected()) {
                    if (!JavaDocLocalInspectionBase.isTagRequired(this.myOptions, this.myTagName)) {
                        this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS + this.myTagName;
                    }
                } else {
                    this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS.replaceAll(this.myTagName, "");
                }
            }
        }
    }
}

