/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflineProblemDescriptorNode
extends ProblemDescriptionNode {
    OfflineProblemDescriptorNode(RefEntity refEntity, CommonProblemDescriptor descriptor, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation, @NotNull OfflineProblemDescriptor offlineDescriptor) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "<init>"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "<init>"));
        }
        if (offlineDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offlineDescriptor", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "<init>"));
        }
        super(refEntity, descriptor, toolWrapper, presentation, false, () -> ((OfflineProblemDescriptor)offlineDescriptor).getLine());
        if (descriptor == null) {
            this.setUserObject(offlineDescriptor);
        }
        this.init(presentation.getContext().getProject());
    }

    static OfflineProblemDescriptorNode create(@NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        if (offlineDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offlineDescriptor", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "create"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "create"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "create"));
        }
        RefEntity refElement = OfflineProblemDescriptorNode.createRefElement(offlineDescriptor, presentation);
        CommonProblemDescriptor descriptor = OfflineProblemDescriptorNode.createDescriptor(refElement, offlineDescriptor, toolWrapper, presentation);
        return new OfflineProblemDescriptorNode(refElement, descriptor, toolWrapper, presentation, offlineDescriptor);
    }

    @Override
    public FileStatus getNodeStatus() {
        return FileStatus.NOT_CHANGED;
    }

    @Override
    @NotNull
    protected String calculatePresentableName() {
        String presentableName = super.calculatePresentableName();
        String string = presentableName.isEmpty() && this.getUserObject() instanceof OfflineProblemDescriptor ? StringUtil.notNullize((String)((OfflineProblemDescriptor)this.getUserObject()).getDescription()) : presentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "calculatePresentableName"));
        }
        return string;
    }

    private static PsiElement[] getElementsIntersectingRange(PsiFile file2, int startOffset, int endOffset) {
        FileViewProvider viewProvider = file2.getViewProvider();
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            result2.addAll(CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, startOffset, endOffset, true));
        }
        return PsiUtilCore.toPsiElementArray(result2);
    }

    @Nullable
    private static RefEntity createRefElement(OfflineProblemDescriptor descriptor, InspectionToolPresentation presentation) {
        return descriptor.getRefElement(presentation.getContext().getRefManager());
    }

    @Nullable
    private static CommonProblemDescriptor createDescriptor(@Nullable RefEntity element, @NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        if (offlineDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offlineDescriptor", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "createDescriptor"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "createDescriptor"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "createDescriptor"));
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)presentation.getContext().getProject());
        OfflineProblemDescriptor offlineProblemDescriptor = offlineDescriptor;
        if (element instanceof RefElement) {
            ProblemDescriptor descriptor;
            PsiElement psiElement = ((RefElement)element).getElement();
            if (psiElement != null && (descriptor = (ProblemDescriptor)ProgressManager.getInstance().runProcess(() -> {
                if (toolWrapper == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "lambda$createDescriptor$0"));
                }
                return OfflineProblemDescriptorNode.runLocalTool(psiElement, inspectionManager, offlineProblemDescriptor, toolWrapper);
            }, (ProgressIndicator)new DaemonProgressIndicator())) != null) {
                return descriptor;
            }
            return null;
        }
        List hints = offlineProblemDescriptor.getHints();
        CommonProblemDescriptor descriptor = inspectionManager.createProblemDescriptor(offlineProblemDescriptor.getDescription(), new QuickFix[]{null});
        LocalQuickFix[] quickFixes = OfflineProblemDescriptorNode.getFixes(descriptor, hints, presentation);
        if (quickFixes != null) {
            descriptor = inspectionManager.createProblemDescriptor(offlineProblemDescriptor.getDescription(), (QuickFix[])quickFixes);
        }
        return descriptor;
    }

    private static ProblemDescriptor runLocalTool(@NotNull PsiElement psiElement, @NotNull InspectionManager inspectionManager, @NotNull OfflineProblemDescriptor offlineProblemDescriptor, @NotNull LocalInspectionToolWrapper toolWrapper) {
        PsiElement[] elementsInRange;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "runLocalTool"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionManager", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "runLocalTool"));
        }
        if (offlineProblemDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offlineProblemDescriptor", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "runLocalTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "runLocalTool"));
        }
        PsiFile containingFile = psiElement.getContainingFile();
        ProblemsHolder holder = new ProblemsHolder(inspectionManager, containingFile, false);
        LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
        int startOffset = psiElement.getTextRange().getStartOffset();
        int endOffset = psiElement.getTextRange().getEndOffset();
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(containingFile, startOffset, endOffset);
        PsiElementVisitor visitor = localTool.buildVisitor(holder, false, session2);
        localTool.inspectionStarted(session2, false);
        for (PsiElement element : elementsInRange = OfflineProblemDescriptorNode.getElementsIntersectingRange(containingFile, startOffset, endOffset)) {
            element.accept(visitor);
        }
        localTool.inspectionFinished(session2, holder);
        if (holder.hasResults()) {
            List list = holder.getResults();
            int idx = offlineProblemDescriptor.getProblemIndex();
            int curIdx = 0;
            for (ProblemDescriptor descriptor : list) {
                PsiNamedElement member = localTool.getProblemElement(descriptor.getPsiElement());
                if (!(psiElement instanceof PsiFile) && (member == null || !member.equals(psiElement))) continue;
                if (curIdx == idx) {
                    return descriptor;
                }
                ++curIdx;
            }
        }
        return null;
    }

    @Nullable
    private static LocalQuickFix[] getFixes(@NotNull CommonProblemDescriptor descriptor, List<String> hints, InspectionToolPresentation presentation) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "getFixes"));
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(hints == null ? 1 : hints.size());
        if (hints == null) {
            OfflineProblemDescriptorNode.addFix(descriptor, fixes, null, presentation);
        } else {
            for (String hint : hints) {
                OfflineProblemDescriptorNode.addFix(descriptor, fixes, hint, presentation);
            }
        }
        return fixes.isEmpty() ? null : fixes.toArray(new LocalQuickFix[fixes.size()]);
    }

    private static void addFix(@NotNull CommonProblemDescriptor descriptor, List<LocalQuickFix> fixes, String hint, InspectionToolPresentation presentation) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "addFix"));
        }
        IntentionAction intentionAction = presentation.findQuickFixes(descriptor, hint);
        if (intentionAction instanceof QuickFixWrapper) {
            fixes.add(((QuickFixWrapper)intentionAction).getFix());
        }
    }
}

