/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sameParameterValue;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SameParameterValueInspectionBase
extends GlobalJavaBatchInspectionTool {
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "checkElement"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "checkElement"));
        }
        ArrayList<ProblemDescriptor> problems = null;
        if (refEntity instanceof RefMethod) {
            RefParameter[] parameters;
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.hasSuperMethods()) {
                return null;
            }
            if (refMethod.isEntry()) {
                return null;
            }
            for (RefParameter refParameter : parameters = refMethod.getParameters()) {
                String value = refParameter.getActualValueIfSame();
                if (value == null || !globalContext.shouldCheck((RefEntity)refParameter, (GlobalInspectionTool)this)) continue;
                if (problems == null) {
                    problems = new ArrayList<ProblemDescriptor>(1);
                }
                String paramName = refParameter.getName();
                problems.add(manager.createProblemDescriptor((PsiElement)refParameter.getElement(), InspectionsBundle.message((String)"inspection.same.parameter.problem.descriptor", (Object[])new Object[]{"<code>" + paramName + "</code>", "<code>" + value + "</code>"}), this.createFix(paramName, value), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false));
            }
        }
        return problems == null ? null : problems.toArray(new CommonProblemDescriptor[problems.size()]);
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "queryExternalUsagesRequests"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "queryExternalUsagesRequests"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "queryExternalUsagesRequests"));
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase$1", "visitElement"));
                }
                if (refEntity instanceof RefElement && processor2.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            if (refMethod == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase$1$1", "visitMethod"));
                            }
                            globalContext.enqueueMethodUsagesProcessor(refMethod, new GlobalJavaInspectionContext.UsagesProcessor(){

                                public boolean process(PsiReference psiReference) {
                                    processor2.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.same.parameter.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("SameParameterValue" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "getShortName"));
        }
        return "SameParameterValue";
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        if (hint == null) {
            return null;
        }
        int spaceIdx = hint.indexOf(32);
        if (spaceIdx == -1 || spaceIdx >= hint.length() - 1) {
            return null;
        }
        String paramName = hint.substring(0, spaceIdx);
        String value = hint.substring(spaceIdx + 1);
        return this.createFix(paramName, value);
    }

    protected LocalQuickFix createFix(String paramName, String value) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspectionBase", "getHint"));
        }
        return fix.toString();
    }
}

