/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;

public class EditSettingsAction
extends InspectionViewActionBase {
    public EditSettingsAction() {
        super(InspectionsBundle.message((String)"inspection.action.edit.settings", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.action.edit.settings", (Object[])new Object[0]), AllIcons.General.Settings);
    }

    public void actionPerformed(AnActionEvent e) {
        final InspectionResultsView view = EditSettingsAction.getView(e);
        InspectionProfile inspectionProfile = view.getCurrentProfile();
        if (view.isSingleInspectionRun()) {
            InspectionToolWrapper tool = inspectionProfile.getInspectionTool(inspectionProfile.getSingleTool(), view.getProject());
            JComponent panel = tool.getTool().createOptionsPanel();
            if (panel != null) {
                DialogBuilder builder = new DialogBuilder().title(InspectionsBundle.message((String)"inspection.tool.window.inspection.dialog.title", (Object[])new Object[]{tool.getDisplayName()})).centerPanel(panel);
                builder.removeAllActions();
                builder.addOkAction();
                if (view.isRerunAvailable()) {
                    builder.addActionDescriptor((DialogBuilder.ActionDescriptor)new DialogBuilder.DialogActionDescriptor(InspectionsBundle.message((String)"inspection.action.rerun", (Object[])new Object[0]), 82){

                        protected Action createAction(final DialogWrapper dialogWrapper) {
                            return new AbstractAction(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    view.rerun();
                                    dialogWrapper.close(0);
                                }
                            };
                        }
                    });
                }
                builder.show();
            } else {
                Messages.showInfoMessage((Project)view.getProject(), (String)InspectionsBundle.message((String)"inspection.tool.window.dialog.no.options", (Object[])new Object[]{tool.getDisplayName()}), (String)InspectionsBundle.message((String)"inspection.tool.window.dialog.title", (Object[])new Object[0]));
            }
        } else {
            HighlightDisplayKey key2;
            InspectionToolWrapper toolWrapper = view.getTree().getSelectedToolWrapper(false);
            if (toolWrapper != null && (key2 = HighlightDisplayKey.find((String)toolWrapper.getShortName())) != null) {
                if (new EditInspectionToolsSettingsAction(key2).editToolSettings(view.getProject(), (InspectionProfileImpl)inspectionProfile, true)) {
                    view.updateCurrentProfile();
                }
                return;
            }
            String[] path = view.getTree().getSelectedGroupPath();
            if (EditInspectionToolsSettingsAction.editSettings(view.getProject(), inspectionProfile, true, c -> {
                if (path != null) {
                    c.selectInspectionGroup(path);
                }
            })) {
                view.updateCurrentProfile();
            }
        }
    }
}

