/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaxSizeTreeSet<E>
implements NavigableSet<E> {
    @NotNull
    private final NavigableSet<E> myUnderlying;
    private final int myMaxSize;

    public MaxSizeTreeSet(int maxSize) {
        this.myMaxSize = maxSize;
        if (this.myMaxSize < 1) {
            throw new IllegalArgumentException();
        }
        this.myUnderlying = new TreeSet();
    }

    @Override
    public E lower(E e) {
        return this.myUnderlying.lower(e);
    }

    @Override
    public E floor(E e) {
        return this.myUnderlying.floor(e);
    }

    @Override
    public E ceiling(E e) {
        return this.myUnderlying.ceiling(e);
    }

    @Override
    public E higher(E e) {
        return this.myUnderlying.higher(e);
    }

    @Override
    public E pollFirst() {
        return this.myUnderlying.pollFirst();
    }

    @Override
    public E pollLast() {
        return this.myUnderlying.pollLast();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Iterator<E> iterator = this.myUnderlying.iterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/MaxSizeTreeSet", "iterator"));
        }
        return iterator;
    }

    @Override
    @NotNull
    public NavigableSet<E> descendingSet() {
        NavigableSet<E> navigableSet = this.myUnderlying.descendingSet();
        if (navigableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/MaxSizeTreeSet", "descendingSet"));
        }
        return navigableSet;
    }

    @Override
    @NotNull
    public Iterator<E> descendingIterator() {
        Iterator<E> iterator = this.myUnderlying.descendingIterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/MaxSizeTreeSet", "descendingIterator"));
        }
        return iterator;
    }

    @Override
    @NotNull
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        NavigableSet<E> navigableSet = this.myUnderlying.subSet(fromElement, fromInclusive, toElement, toInclusive);
        if (navigableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/MaxSizeTreeSet", "subSet"));
        }
        return navigableSet;
    }

    @Override
    @NotNull
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        NavigableSet<E> navigableSet = this.myUnderlying.headSet(toElement, inclusive);
        if (navigableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/MaxSizeTreeSet", "headSet"));
        }
        return navigableSet;
    }

    @Override
    @NotNull
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        NavigableSet<E> navigableSet = this.myUnderlying.tailSet(fromElement, inclusive);
        if (navigableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/MaxSizeTreeSet", "tailSet"));
        }
        return navigableSet;
    }

    @Override
    @NotNull
    public SortedSet<E> subSet(E fromElement, E toElement) {
        SortedSet<E> sortedSet = this.myUnderlying.subSet(fromElement, toElement);
        if (sortedSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/MaxSizeTreeSet", "subSet"));
        }
        return sortedSet;
    }

    @Override
    @NotNull
    public SortedSet<E> headSet(E toElement) {
        SortedSet<E> sortedSet = this.myUnderlying.headSet(toElement);
        if (sortedSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/MaxSizeTreeSet", "headSet"));
        }
        return sortedSet;
    }

    @Override
    @NotNull
    public SortedSet<E> tailSet(E fromElement) {
        SortedSet<E> sortedSet = this.myUnderlying.tailSet(fromElement);
        if (sortedSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/MaxSizeTreeSet", "tailSet"));
        }
        return sortedSet;
    }

    @Override
    @Nullable
    public Comparator<? super E> comparator() {
        return this.myUnderlying.comparator();
    }

    @Override
    public E first() {
        return this.myUnderlying.first();
    }

    @Override
    public E last() {
        return this.myUnderlying.last();
    }

    @Override
    public int size() {
        return this.myUnderlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myUnderlying.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.myUnderlying.contains(o);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = this.myUnderlying.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/MaxSizeTreeSet", "toArray"));
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(T[] a) {
        T[] TArray = this.myUnderlying.toArray(a);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/MaxSizeTreeSet", "toArray"));
        }
        return TArray;
    }

    @Override
    public boolean add(E e) {
        if (this.myUnderlying.size() == this.myMaxSize) {
            boolean isAdded;
            Comparator<E> comparator2 = this.comparator();
            if ((comparator2 == null ? ((Comparable)e).compareTo(this.last()) : comparator2.compare(e, this.last())) < 0 && (isAdded = this.myUnderlying.add(e))) {
                this.pollLast();
                return true;
            }
            return false;
        }
        return this.myUnderlying.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.myUnderlying.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.myUnderlying.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.myUnderlying.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.myUnderlying.removeAll(c);
    }

    @Override
    public void clear() {
        this.myUnderlying.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaxSizeTreeSet)) {
            return false;
        }
        MaxSizeTreeSet that = (MaxSizeTreeSet)o;
        return this.myUnderlying.equals(that.myUnderlying);
    }

    @Override
    public int hashCode() {
        return this.myUnderlying.hashCode();
    }

    public String toString() {
        return this.myUnderlying.toString();
    }
}

