/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch.context;

import com.intellij.compiler.classFilesIndex.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ChainCompletionContextStringUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ContextRelevantVariableGetter;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.TargetType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContextUtil {
    private static final String JAVA_LANG_STRING_SHORT_NAME = StringUtil.getShortName((String)"java.lang.String");

    @Nullable
    public static ChainCompletionContext createContext(@Nullable PsiType variableType, @Nullable String variableName, @Nullable PsiElement containingElement) {
        TargetType target;
        if (variableType == null || containingElement == null) {
            return null;
        }
        if (variableType instanceof PsiClassType) {
            target = TargetType.create((PsiClassType)variableType);
        } else if (variableType instanceof PsiArrayType) {
            target = TargetType.create((PsiArrayType)variableType);
        } else {
            return null;
        }
        if (target == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)containingElement, PsiMethod.class);
        if (method == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        Set<String> containingClassQNames = ContextUtil.resolveSupersNamesRecursively(aClass);
        SmartList contextVars = new SmartList();
        for (PsiField psiField : aClass.getFields()) {
            PsiClass containingClass = psiField.getContainingClass();
            if (containingClass == null || !psiField.hasModifierProperty("public") && !psiField.hasModifierProperty("protected") && (!psiField.hasModifierProperty("private") && !psiField.hasModifierProperty("packageLocal") || !aClass.isEquivalentTo((PsiElement)containingClass)) || psiField.getName().equals(variableName)) continue;
            contextVars.add(psiField);
        }
        Collections.addAll(contextVars, method.getParameterList().getParameters());
        PsiCodeBlock methodBody = method.getBody();
        assert (methodBody != null);
        boolean processMethodTail = false;
        ArrayList<PsiElement> afterElements = new ArrayList<PsiElement>();
        for (PsiElement element : methodBody.getChildren()) {
            if (element.isEquivalentTo(containingElement)) {
                if (!(variableType instanceof PsiClassType)) break;
                processMethodTail = true;
                continue;
            }
            if (!(element instanceof PsiDeclarationStatement)) continue;
            if (processMethodTail) {
                afterElements.add(element);
                continue;
            }
            for (PsiElement declaredElement : ((PsiDeclarationStatement)element).getDeclaredElements()) {
                if (!(declaredElement instanceof PsiLocalVariable) || variableName != null && variableName.equals(((PsiLocalVariable)declaredElement).getName())) continue;
                contextVars.add((PsiVariable)declaredElement);
            }
        }
        Set<String> set = processMethodTail ? ContextUtil.generateExcludedQNames(afterElements, ((PsiClassType)variableType).resolve(), variableName, (List<PsiVariable>)contextVars) : Collections.emptySet();
        ArrayList<PsiMethod> contextMethods = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : aClass.getMethods()) {
            if (!psiMethod.hasModifierProperty("protected") && !psiMethod.hasModifierProperty("private") || psiMethod.getParameterList().getParametersCount() != 0) continue;
            contextMethods.add(psiMethod);
        }
        return ContextUtil.create(target, (List<PsiVariable>)contextVars, contextMethods, containingClassQNames, containingElement.getProject(), containingElement.getResolveScope(), set);
    }

    private static Set<String> generateExcludedQNames(List<PsiElement> tailElements, @Nullable PsiClass psiClass, @Nullable String varName, List<PsiVariable> contextVars) {
        if (psiClass == null) {
            return Collections.emptySet();
        }
        String classQName = psiClass.getQualifiedName();
        if (classQName == null) {
            return Collections.emptySet();
        }
        HashSet<String> excludedQNames = new HashSet<String>();
        if (!tailElements.isEmpty()) {
            HashSet<String> contextVarTypes = new HashSet<String>();
            HashMap<String, PsiVariable> contextVarNamesToVar = new HashMap<String, PsiVariable>();
            for (PsiVariable var : contextVars) {
                contextVarTypes.add(var.getType().getCanonicalText());
                contextVarNamesToVar.put(var.getName(), var);
            }
            for (PsiElement element : tailElements) {
                Collection methodCallExpressions = PsiTreeUtil.findChildrenOfType((PsiElement)element, PsiMethodCallExpression.class);
                for (PsiMethodCallExpression methodCallExpression : methodCallExpressions) {
                    PsiType returnType;
                    PsiExpressionList args = methodCallExpression.getArgumentList();
                    PsiMethod resolvedMethod = methodCallExpression.resolveMethod();
                    if (resolvedMethod == null || (returnType = resolvedMethod.getReturnType()) == null) continue;
                    String returnTypeAsString = returnType.getCanonicalText();
                    for (PsiExpression expression : args.getExpressions()) {
                        String qVarName = expression.getText();
                        if (qVarName == null || !contextVarNamesToVar.containsKey(qVarName) && !qVarName.equals(varName)) continue;
                        excludedQNames.add(returnTypeAsString);
                    }
                    if (contextVarTypes.contains(returnTypeAsString)) continue;
                    excludedQNames.add(returnTypeAsString);
                }
            }
        }
        return excludedQNames;
    }

    @Nullable
    private static ChainCompletionContext create(TargetType target, List<PsiVariable> contextVars, List<PsiMethod> contextMethods, Set<String> containingClassQNames, Project project2, GlobalSearchScope resolveScope, Set<String> excludedQNames) {
        MultiMap classQNameToVariable = new MultiMap();
        MultiMap containingClassGetters = new MultiMap();
        MultiMap contextVarsGetters = new MultiMap();
        HashMap<String, PsiVariable> stringVars = new HashMap<String, PsiVariable>();
        for (PsiMethod method : contextMethods) {
            PsiType returnType = method.getReturnType();
            if (returnType == null) continue;
            String returnTypeQName = returnType.getCanonicalText();
            containingClassGetters.putValue((Object)returnTypeQName, (Object)method);
        }
        for (PsiVariable var : contextVars) {
            PsiType type = var.getType();
            HashSet<String> classQNames = new HashSet<String>();
            if (type instanceof PsiClassType) {
                String varName;
                if (JAVA_LANG_STRING_SHORT_NAME.equals(((PsiClassType)type).getClassName()) && (varName = var.getName()) != null) {
                    stringVars.put(ChainCompletionContextStringUtil.sanitizedToLowerCase(varName), var);
                    continue;
                }
                PsiClass aClass = ((PsiClassType)type).resolve();
                if (aClass != null) {
                    String classQName = type.getCanonicalText();
                    if (!target.getClassQName().equals(classQName)) {
                        classQNames.add(classQName);
                        classQNames.addAll(ContextUtil.resolveSupersNamesRecursively(aClass));
                        for (PsiMethod method : aClass.getAllMethods()) {
                            PsiType returnType;
                            if (method.getParameterList().getParametersCount() != 0 || !method.getName().startsWith("get") || (returnType = method.getReturnType()) == null) continue;
                            String getterReturnTypeQName = returnType.getCanonicalText();
                            contextVarsGetters.putValue((Object)getterReturnTypeQName, (Object)new ContextRelevantVariableGetter(var, method));
                        }
                    }
                }
            } else {
                String classQName = type.getCanonicalText();
                classQNames.add(classQName);
            }
            for (String qName : classQNames) {
                classQNameToVariable.putValue((Object)qName, (Object)var);
            }
        }
        return new ChainCompletionContext(target, containingClassQNames, (MultiMap<String, PsiVariable>)classQNameToVariable, (MultiMap<String, PsiMethod>)containingClassGetters, (MultiMap<String, ContextRelevantVariableGetter>)contextVarsGetters, stringVars, excludedQNames, project2, resolveScope);
    }

    @NotNull
    private static Set<String> resolveSupersNamesRecursively(@Nullable PsiClass psiClass) {
        HashSet<String> result2 = new HashSet<String>();
        if (psiClass != null) {
            for (PsiClass superClass : psiClass.getSupers()) {
                String qualifiedName = superClass.getQualifiedName();
                if ("java.lang.Object".equals(qualifiedName)) continue;
                if (qualifiedName != null) {
                    result2.add(qualifiedName);
                }
                result2.addAll(ContextUtil.resolveSupersNamesRecursively(superClass));
            }
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/context/ContextUtil", "resolveSupersNamesRecursively"));
        }
        return hashSet;
    }
}

