/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.server.AutomakeCompileContext;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.notification.Notification;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import java.util.Collections;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineRemoteProto;

class AutoMakeMessageHandler
extends DefaultMessageHandler {
    private static final Key<Notification> LAST_AUTO_MAKE_NOFITICATION = Key.create((String)"LAST_AUTO_MAKE_NOFITICATION");
    private CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status myBuildStatus;
    private final Project myProject;
    private final WolfTheProblemSolver myWolf;
    private volatile boolean myUnprocessedFSChangesDetected = false;
    private final AutomakeCompileContext myContext;

    public AutoMakeMessageHandler(Project project2) {
        super(project2);
        this.myProject = project2;
        this.myBuildStatus = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.SUCCESS;
        this.myWolf = WolfTheProblemSolver.getInstance((Project)project2);
        this.myContext = new AutomakeCompileContext(project2);
    }

    public boolean unprocessedFSChangesDetected() {
        return this.myUnprocessedFSChangesDetected;
    }

    @Override
    public void buildStarted(UUID sessionId) {
    }

    @Override
    protected void handleBuildEvent(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event) {
        if (this.myProject.isDisposed()) {
            return;
        }
        switch (event.getEventType()) {
            case BUILD_COMPLETED: {
                this.myContext.getProgressIndicator().stop();
                if (event.hasCompletionStatus()) {
                    CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status2;
                    this.myBuildStatus = status2 = event.getCompletionStatus();
                    if (status2 == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.CANCELED) {
                        this.myContext.getProgressIndicator().cancel();
                    }
                }
                int errors = this.myContext.getMessageCount(CompilerMessageCategory.ERROR);
                int warnings = this.myContext.getMessageCount(CompilerMessageCategory.WARNING);
                SwingUtilities.invokeLater(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    CompilationStatusListener publisher = (CompilationStatusListener)this.myProject.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
                    publisher.automakeCompilationFinished(errors, warnings, (CompileContext)this.myContext);
                });
                return;
            }
            case FILES_GENERATED: {
                CompilationStatusListener publisher = (CompilationStatusListener)this.myProject.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
                for (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile generatedFile : event.getGeneratedFilesList()) {
                    String root = FileUtil.toSystemIndependentName((String)generatedFile.getOutputRoot());
                    String relativePath = FileUtil.toSystemIndependentName((String)generatedFile.getRelativePath());
                    publisher.fileGenerated(root, relativePath);
                }
                return;
            }
            case CUSTOM_BUILDER_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage message;
                if (event.hasCustomBuilderMessage() && "JPS".equals((message = event.getCustomBuilderMessage()).getBuilderId()) && "!unprocessed_fs_changes_detected!".equals(message.getMessageType())) {
                    this.myUnprocessedFSChangesDetected = true;
                }
                return;
            }
        }
    }

    @Override
    protected void handleCompileMessage(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage message) {
        if (this.myProject.isDisposed()) {
            return;
        }
        CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind = message.getKind();
        if (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.PROGRESS) {
            ProblemsView view = ProblemsView.SERVICE.getInstance(this.myProject);
            if (message.hasDone()) {
                view.setProgress(message.getText(), message.getDone());
            } else {
                view.setProgress(message.getText());
            }
        } else {
            CompilerMessageCategory category = AutoMakeMessageHandler.convertToCategory(kind);
            if (category != null) {
                String sourceFilePath = message.hasSourceFilePath() ? message.getSourceFilePath() : null;
                String url = sourceFilePath != null ? VirtualFileManager.constructUrl((String)"file", (String)FileUtil.toSystemIndependentName((String)sourceFilePath)) : null;
                long line = message.hasLine() ? message.getLine() : -1L;
                long column = message.hasColumn() ? message.getColumn() : -1L;
                CompilerMessage msg = this.myContext.createAndAddMessage(category, message.getText(), url, (int)line, (int)column, null);
                if (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.ERROR) {
                    this.informWolf(this.myProject, message);
                    if (msg != null) {
                        ProblemsView.SERVICE.getInstance(this.myProject).addMessage(msg, sessionId);
                    }
                }
            }
        }
    }

    @Nullable
    private static CompilerMessageCategory convertToCategory(CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind) {
        switch (kind) {
            case ERROR: {
                return CompilerMessageCategory.ERROR;
            }
            case INFO: {
                return CompilerMessageCategory.INFORMATION;
            }
            case WARNING: {
                return CompilerMessageCategory.WARNING;
            }
        }
        return null;
    }

    @Override
    public void handleFailure(UUID sessionId, CmdlineRemoteProto.Message.Failure failure) {
        String descr;
        if (this.myProject.isDisposed()) {
            return;
        }
        String string = descr = failure.hasDescription() ? failure.getDescription() : null;
        if (descr == null) {
            descr = failure.hasStacktrace() ? failure.getStacktrace() : "";
        }
        String msg = "Auto make failure: " + descr;
        CompilerManager.NOTIFICATION_GROUP.createNotification(msg, MessageType.INFO);
        ProblemsView.SERVICE.getInstance(this.myProject).addMessage(new CompilerMessageImpl(this.myProject, CompilerMessageCategory.ERROR, msg), sessionId);
    }

    @Override
    public void sessionTerminated(UUID sessionId) {
        Notification notification;
        String statusMessage = null;
        switch (this.myBuildStatus) {
            case SUCCESS: {
                break;
            }
            case UP_TO_DATE: {
                break;
            }
            case ERRORS: {
                statusMessage = "Auto make completed with errors";
                break;
            }
        }
        if (statusMessage != null) {
            notification = CompilerManager.NOTIFICATION_GROUP.createNotification(statusMessage, MessageType.INFO);
            if (!this.myProject.isDisposed()) {
                notification.notify(this.myProject);
            }
            this.myProject.putUserData(LAST_AUTO_MAKE_NOFITICATION, (Object)notification);
        } else {
            notification = (Notification)this.myProject.getUserData(LAST_AUTO_MAKE_NOFITICATION);
            if (notification != null) {
                notification.expire();
                this.myProject.putUserData(LAST_AUTO_MAKE_NOFITICATION, null);
            }
        }
        if (!this.myProject.isDisposed()) {
            ProblemsView view = ProblemsView.SERVICE.getInstance(this.myProject);
            view.clearProgress();
            view.clearOldMessages(null, sessionId);
        }
    }

    private void informWolf(Project project2, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage message) {
        VirtualFile vFile;
        String srcPath = message.getSourceFilePath();
        if (srcPath != null && !project2.isDisposed() && (vFile = LocalFileSystem.getInstance().findFileByPath(srcPath)) != null) {
            int line = (int)message.getLine();
            int column = (int)message.getColumn();
            if (line > 0 && column > 0) {
                Problem problem = this.myWolf.convertToProblem(vFile, line, column, new String[]{message.getText()});
                this.myWolf.weHaveGotProblems(vFile, Collections.singletonList(problem));
            } else {
                this.myWolf.queue(vFile);
            }
        }
    }
}

