/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJavaCodeStyleManager
extends JavaCodeStyleManager {
    public boolean addImport(@NotNull PsiJavaFile file2, @NotNull PsiClass refClass) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreJavaCodeStyleManager", "addImport"));
        }
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/core/CoreJavaCodeStyleManager", "addImport"));
        }
        return false;
    }

    @NotNull
    public PsiElement shortenClassReferences(@NotNull PsiElement element, int flags) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/core/CoreJavaCodeStyleManager", "shortenClassReferences"));
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaCodeStyleManager", "shortenClassReferences"));
        }
        return psiElement;
    }

    @NotNull
    public String getPrefixByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/core/CoreJavaCodeStyleManager", "getPrefixByVariableKind"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaCodeStyleManager", "getPrefixByVariableKind"));
        }
        return "";
    }

    @NotNull
    public String getSuffixByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/core/CoreJavaCodeStyleManager", "getSuffixByVariableKind"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaCodeStyleManager", "getSuffixByVariableKind"));
        }
        return "";
    }

    public int findEntryIndex(@NotNull PsiImportStatementBase statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/core/CoreJavaCodeStyleManager", "findEntryIndex"));
        }
        return 0;
    }

    public PsiElement shortenClassReferences(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/core/CoreJavaCodeStyleManager", "shortenClassReferences"));
        }
        return element;
    }

    public void shortenClassReferences(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/core/CoreJavaCodeStyleManager", "shortenClassReferences"));
        }
    }

    public void optimizeImports(@NotNull PsiFile file2) throws IncorrectOperationException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreJavaCodeStyleManager", "optimizeImports"));
        }
    }

    public PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreJavaCodeStyleManager", "prepareOptimizeImportsResult"));
        }
        return null;
    }

    @NotNull
    public SuggestedNameInfo suggestVariableName(@NotNull VariableKind kind, @Nullable String propertyName, @Nullable PsiExpression expr, @Nullable PsiType type, boolean correctKeywords) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/core/CoreJavaCodeStyleManager", "suggestVariableName"));
        }
        SuggestedNameInfo suggestedNameInfo = SuggestedNameInfo.NULL_INFO;
        if (suggestedNameInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaCodeStyleManager", "suggestVariableName"));
        }
        return suggestedNameInfo;
    }

    @NotNull
    public String variableNameToPropertyName(@NotNull @NonNls String name, @NotNull VariableKind variableKind) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreJavaCodeStyleManager", "variableNameToPropertyName"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/core/CoreJavaCodeStyleManager", "variableNameToPropertyName"));
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaCodeStyleManager", "variableNameToPropertyName"));
        }
        return string;
    }

    @NotNull
    public String propertyNameToVariableName(@NotNull @NonNls String propertyName, @NotNull VariableKind variableKind) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/core/CoreJavaCodeStyleManager", "propertyNameToVariableName"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "com/intellij/core/CoreJavaCodeStyleManager", "propertyNameToVariableName"));
        }
        String string = propertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaCodeStyleManager", "propertyNameToVariableName"));
        }
        return string;
    }

    @NotNull
    public String suggestUniqueVariableName(@NotNull @NonNls String baseName, PsiElement place, boolean lookForward) {
        String name;
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/core/CoreJavaCodeStyleManager", "suggestUniqueVariableName"));
        }
        int index = 0;
        PsiElement scope = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class, PsiMethod.class});
        block2: while (true) {
            name = baseName;
            if (index > 0) {
                name = name + index;
            }
            ++index;
            if (!PsiUtil.isVariableNameUnique((String)name, (PsiElement)place)) continue;
            if (!lookForward) break;
            final String name1 = name;
            for (PsiElement run = scope; run != null; run = run.getNextSibling()) {
                class CancelException
                extends RuntimeException {
                    CancelException() {
                    }
                }
                try {
                    run.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitAnonymousClass(PsiAnonymousClass aClass) {
                        }

                        public void visitVariable(PsiVariable variable) {
                            if (name1.equals(variable.getName())) {
                                throw new CancelException();
                            }
                        }
                    });
                    continue;
                }
                catch (CancelException e) {
                    continue block2;
                }
            }
            break;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaCodeStyleManager", "suggestUniqueVariableName"));
        }
        return string;
    }

    @NotNull
    public SuggestedNameInfo suggestUniqueVariableName(final @NotNull SuggestedNameInfo baseNameInfo, PsiElement place, boolean ignorePlaceName, boolean lookForward) {
        if (baseNameInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseNameInfo", "com/intellij/core/CoreJavaCodeStyleManager", "suggestUniqueVariableName"));
        }
        String[] names = baseNameInfo.names;
        LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>(names.length);
        for (String name : names) {
            String placeName;
            if (ignorePlaceName && place instanceof PsiNamedElement && Comparing.strEqual((String)(placeName = ((PsiNamedElement)place).getName()), (String)name)) {
                uniqueNames.add(name);
                continue;
            }
            uniqueNames.add(this.suggestUniqueVariableName(name, place, lookForward));
        }
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(ArrayUtil.toStringArray(uniqueNames)){

            public void nameChosen(String name) {
                baseNameInfo.nameChosen(name);
            }
        };
        if (suggestedNameInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaCodeStyleManager", "suggestUniqueVariableName"));
        }
        return suggestedNameInfo;
    }

    @NotNull
    public PsiElement qualifyClassReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/core/CoreJavaCodeStyleManager", "qualifyClassReferences"));
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaCodeStyleManager", "qualifyClassReferences"));
        }
        return psiElement;
    }

    public void removeRedundantImports(@NotNull PsiJavaFile file2) throws IncorrectOperationException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreJavaCodeStyleManager", "removeRedundantImports"));
        }
    }

    public Collection<PsiImportStatementBase> findRedundantImports(@NotNull PsiJavaFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreJavaCodeStyleManager", "findRedundantImports"));
        }
        return null;
    }
}

