/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CorePackageIndex
extends PackageIndex {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.core.CorePackageIndex");
    private final List<VirtualFile> myClasspath = new ArrayList<VirtualFile>();

    private List<VirtualFile> roots() {
        return this.myClasspath;
    }

    private List<VirtualFile> findDirectoriesByPackageName(String packageName) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        String dirName = packageName.replace(".", "/");
        for (VirtualFile root : this.roots()) {
            VirtualFile classDir = root.findFileByRelativePath(dirName);
            if (classDir == null) continue;
            result2.add(classDir);
        }
        return result2;
    }

    public VirtualFile[] getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/core/CorePackageIndex", "getDirectoriesByPackageName"));
        }
        return (VirtualFile[])this.getDirsByPackageName(packageName, includeLibrarySources).toArray((Object[])VirtualFile.EMPTY_ARRAY);
    }

    public Query<VirtualFile> getDirsByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/core/CorePackageIndex", "getDirsByPackageName"));
        }
        return new CollectionQuery(this.findDirectoriesByPackageName(packageName));
    }

    public void addToClasspath(VirtualFile root) {
        this.myClasspath.add(root);
    }
}

