/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaMethodFilter
implements BreakpointStepMethodFilter {
    public static final String LAMBDA_METHOD_PREFIX = "lambda$";
    private final int myLambdaOrdinal;
    @Nullable
    private final SourcePosition myFirstStatementPosition;
    private final int myLastStatementLine;
    private final Range<Integer> myCallingExpressionLines;

    public LambdaMethodFilter(PsiLambdaExpression lambda2, int expressionOrdinal, Range<Integer> callingExpressionLines) {
        this.myLambdaOrdinal = expressionOrdinal;
        this.myCallingExpressionLines = callingExpressionLines;
        SourcePosition firstStatementPosition = null;
        SourcePosition lastStatementPosition = null;
        PsiElement body = lambda2.getBody();
        if (body instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)body).getStatements();
            if (statements.length > 0 && (firstStatementPosition = SourcePosition.createFromElement((PsiElement)statements[0])) != null) {
                PsiStatement lastStatement = statements[statements.length - 1];
                lastStatementPosition = SourcePosition.createFromOffset((PsiFile)firstStatementPosition.getFile(), (int)lastStatement.getTextRange().getEndOffset());
            }
        } else if (body != null) {
            firstStatementPosition = SourcePosition.createFromElement((PsiElement)body);
        }
        this.myFirstStatementPosition = firstStatementPosition;
        this.myLastStatementLine = lastStatementPosition != null ? lastStatementPosition.getLine() : -1;
    }

    public int getLambdaOrdinal() {
        return this.myLambdaOrdinal;
    }

    @Override
    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.myFirstStatementPosition;
    }

    @Override
    public int getLastStatementLine() {
        return this.myLastStatementLine;
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process2, Location location) throws EvaluateException {
        VirtualMachineProxyImpl vm = process2.getVirtualMachineProxy();
        Method method = location.method();
        return LambdaMethodFilter.isLambdaName(method.name()) && (!vm.canGetSyntheticAttribute() || method.isSynthetic());
    }

    @Override
    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }

    public static boolean isLambdaName(@Nullable String name) {
        return !StringUtil.isEmpty((String)name) && name.startsWith(LAMBDA_METHOD_PREFIX);
    }

    public static int getLambdaOrdinal(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/engine/LambdaMethodFilter", "getLambdaOrdinal"));
        }
        int pos = name.lastIndexOf(36);
        if (pos > -1) {
            try {
                return Integer.parseInt(name.substring(pos + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }
}

