/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.NavigationItem;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SourceCodeChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.SourceCodeChecker");

    private SourceCodeChecker() {
    }

    public static void checkSource(final DebuggerContextImpl debuggerContext) {
        if (!Registry.is((String)"debugger.check.source")) {
            return;
        }
        final SuspendContextImpl suspendContext = debuggerContext.getSuspendContext();
        if (suspendContext == null) {
            return;
        }
        suspendContext.getDebugProcess().getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.LOW;
            }

            @Override
            public void contextAction() throws Exception {
                try {
                    StackFrameProxyImpl frameProxy = debuggerContext.getFrameProxy();
                    if (frameProxy == null) {
                        return;
                    }
                    Location location = frameProxy.location();
                    SourceCodeChecker.check(location, debuggerContext.getSourcePosition(), suspendContext.getDebugProcess().getProject());
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                }
                catch (AbsentInformationException absentInformationException) {
                    // empty catch block
                }
            }
        });
    }

    private static ThreeState check(Location location, SourcePosition position, Project project2) throws AbsentInformationException {
        Method method = location.method();
        if (method.isConstructor() || method.isSynthetic() || method.isBridge() || method.isStaticInitializer() || method.declaringType() instanceof ClassType && ((ClassType)method.declaringType()).isEnum() || LambdaMethodFilter.isLambdaName(method.name())) {
            return ThreeState.UNSURE;
        }
        List<Location> locations = method.allLineLocations();
        if (ContainerUtil.isEmpty(locations)) {
            return ThreeState.UNSURE;
        }
        if (position != null) {
            return (ThreeState)ApplicationManager.getApplication().runReadAction(() -> {
                PsiFile psiFile = position.getFile();
                if (!psiFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
                    return ThreeState.UNSURE;
                }
                Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
                if (document2 == null) {
                    return ThreeState.UNSURE;
                }
                boolean res = false;
                PsiElement psiMethod = DebuggerUtilsEx.getContainingMethod(position);
                if (psiMethod != null) {
                    PsiDocComment comment;
                    TextRange range = psiMethod.getTextRange();
                    if (psiMethod instanceof PsiDocCommentOwner && (comment = ((PsiDocCommentOwner)psiMethod).getDocComment()) != null) {
                        range = new TextRange(comment.getTextRange().getEndOffset() + 1, range.getEndOffset());
                    }
                    int startLine = document2.getLineNumber(range.getStartOffset()) + 1;
                    int endLine = document2.getLineNumber(range.getEndOffset()) + 1;
                    res = SourceCodeChecker.getLinesStream(locations, psiFile).allMatch(line -> startLine <= line && line <= endLine);
                    if (!res) {
                        LOG.debug("Source check failed: Method " + method.name() + ", source: " + ((NavigationItem)psiMethod).getName() + "\nLines: " + SourceCodeChecker.getLinesStream(locations, psiFile).mapToObj(Integer::toString).collect(Collectors.joining(", ")) + "\nExpected range: " + startLine + "-" + endLine);
                    }
                } else {
                    LOG.debug("Source check failed: method " + method.name() + " not found in sources");
                }
                if (!res) {
                    FileEditor editor = FileEditorManager.getInstance((Project)project2).getSelectedEditor(position.getFile().getVirtualFile());
                    if (editor instanceof TextEditor) {
                        AppUIUtil.invokeOnEdt(() -> HintManager.getInstance().showErrorHint(((TextEditor)editor).getEditor(), DebuggerBundle.message((String)"warning.source.code.not.match", (Object[])new Object[0])));
                    } else {
                        XDebugSessionImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"warning.source.code.not.match", (Object[])new Object[0]), NotificationType.WARNING).notify(project2);
                    }
                    return ThreeState.NO;
                }
                return ThreeState.YES;
            });
        }
        return ThreeState.YES;
    }

    private static IntStream getLinesStream(List<Location> locations, PsiFile psiFile) {
        IntStream stream = locations.stream().mapToInt(Location::lineNumber);
        if (psiFile instanceof PsiCompiledFile) {
            stream = stream.map(line -> DebuggerUtilsEx.bytecodeToSourceLine(psiFile, line));
        }
        return stream.filter(line -> line >= 0);
    }

    private static void checkAllClasses(DebuggerContextImpl debuggerContext) {
        DebugProcessImpl process2 = debuggerContext.getDebugProcess();
        VirtualMachine machine = process2.getVirtualMachineProxy().getVirtualMachine();
        PositionManagerImpl positionManager = new PositionManagerImpl(process2);
        List<ReferenceType> types = machine.allClasses();
        System.out.println("Checking " + types.size() + " classes");
        int i = 0;
        block2: for (ReferenceType type : types) {
            ++i;
            try {
                for (Location loc : type.allLineLocations()) {
                    SourcePosition position = (SourcePosition)ApplicationManager.getApplication().runReadAction(() -> {
                        try {
                            return positionManager.getSourcePosition(loc);
                        }
                        catch (NoDataException ignore) {
                            return null;
                        }
                    });
                    if (position == null) continue;
                    if (position.getFile() instanceof PsiCompiledFile) {
                        VirtualFile file2 = position.getFile().getVirtualFile();
                        if (file2 == null || file2.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY) == null) continue block2;
                        if (DebuggerUtilsEx.bytecodeToSourceLine(position.getFile(), loc.lineNumber()) == -1) continue;
                    }
                    if (SourceCodeChecker.check(loc, position, process2.getProject()) != ThreeState.NO) continue;
                    System.out.println("failed " + type);
                }
            }
            catch (AbsentInformationException absentInformationException) {}
        }
        System.out.println("Done checking");
    }
}

