/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class HotSwapProgressImpl
extends HotSwapProgress {
    static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"HotSwap", (String)ToolWindowId.DEBUG);
    private final TIntObjectHashMap<List<String>> myMessages = new TIntObjectHashMap();
    private final ProgressWindow myProgressWindow;
    private String myTitle = DebuggerBundle.message((String)"progress.hot.swap.title", (Object[])new Object[0]);
    private final MergingUpdateQueue myUpdateQueue;
    private XDebugSession mySessionToRestartOnFail;

    public HotSwapProgressImpl(Project project2) {
        super(project2);
        this.myProgressWindow = new BackgroundableProcessIndicator(this.getProject(), this.myTitle, new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return DebuggerSettings.getInstance().HOTSWAP_IN_BACKGROUND;
            }

            public void processSentToBackground() {
            }
        }, null, null, true);
        this.myProgressWindow.addStateDelegate(new AbstractProgressIndicatorExBase(){

            @Override
            public void cancel() {
                super.cancel();
                HotSwapProgressImpl.this.cancel();
            }
        });
        this.myUpdateQueue = new MergingUpdateQueue("HotSwapProgress update queue", 100, true, null, (Disposable)this.myProgressWindow);
    }

    @Override
    public void finished() {
        super.finished();
        List<String> errors = this.getMessages(4);
        List<String> warnings = this.getMessages(5);
        if (!errors.isEmpty()) {
            String message = DebuggerBundle.message((String)"status.hot.swap.completed.with.errors", (Object[])new Object[0]);
            if (this.mySessionToRestartOnFail != null) {
                message = message + " " + DebuggerBundle.message((String)"status.hot.swap.completed.with.errors.restart", (Object[])new Object[0]);
            }
            NOTIFICATION_GROUP.createNotification(message, HotSwapProgressImpl.buildMessage(errors), NotificationType.ERROR, (notification, event) -> {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && this.mySessionToRestartOnFail != null) {
                    notification.expire();
                    ExecutionEnvironment environment = ((XDebugSessionImpl)this.mySessionToRestartOnFail).getExecutionEnvironment();
                    if (environment != null) {
                        ExecutionUtil.restart((ExecutionEnvironment)environment);
                    }
                }
            }).setImportant(false).notify(this.getProject());
        } else if (!warnings.isEmpty()) {
            NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"status.hot.swap.completed.with.warnings", (Object[])new Object[0]), HotSwapProgressImpl.buildMessage(warnings), NotificationType.WARNING, null).notify(this.getProject());
        } else if (!this.myMessages.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (int category : this.myMessages.keys()) {
                messages.addAll(this.getMessages(category));
            }
            NOTIFICATION_GROUP.createNotification(HotSwapProgressImpl.buildMessage(messages), NotificationType.INFORMATION).notify(this.getProject());
        }
    }

    public void setSessionToRestartOnFail(@NotNull DebuggerSession sessionToRestartOnFail) {
        if (sessionToRestartOnFail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionToRestartOnFail", "com/intellij/debugger/ui/HotSwapProgressImpl", "setSessionToRestartOnFail"));
        }
        this.mySessionToRestartOnFail = sessionToRestartOnFail.getXDebugSession();
    }

    private List<String> getMessages(int category) {
        return ContainerUtil.notNullize((List)((List)this.myMessages.get(category)));
    }

    private static String buildMessage(List<String> messages) {
        return StringUtil.trimEnd((String)StringUtil.join(messages, (String)" \n").trim(), (String)";");
    }

    @Override
    public void addMessage(DebuggerSession session2, int type, String text) {
        List messages = (List)this.myMessages.get(type);
        if (messages == null) {
            messages = new SmartList();
            this.myMessages.put(type, (Object)messages);
        }
        messages.add(session2.getSessionName() + ": " + text + ";");
    }

    @Override
    public void setText(final String text) {
        this.myUpdateQueue.queue(new Update("Text"){

            public void run() {
                DebuggerInvocationUtil.invokeLater(HotSwapProgressImpl.this.getProject(), () -> {
                    if (!HotSwapProgressImpl.this.myProgressWindow.isCanceled() && HotSwapProgressImpl.this.myProgressWindow.isRunning()) {
                        HotSwapProgressImpl.this.myProgressWindow.setText(text);
                    }
                }, HotSwapProgressImpl.this.myProgressWindow.getModalityState());
            }
        });
    }

    @Override
    public void setTitle(String text) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> {
            if (!this.myProgressWindow.isCanceled() && this.myProgressWindow.isRunning()) {
                this.myProgressWindow.setTitle(text);
            }
        }, this.myProgressWindow.getModalityState());
    }

    @Override
    public void setFraction(double v) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> {
            if (!this.myProgressWindow.isCanceled() && this.myProgressWindow.isRunning()) {
                this.myProgressWindow.setFraction(v);
            }
        }, this.myProgressWindow.getModalityState());
    }

    @Override
    public boolean isCancelled() {
        return this.myProgressWindow.isCanceled();
    }

    public ProgressIndicator getProgressIndicator() {
        return this.myProgressWindow;
    }

    @Override
    public void setDebuggerSession(DebuggerSession session2) {
        this.myTitle = DebuggerBundle.message((String)"progress.hot.swap.title", (Object[])new Object[0]) + " : " + session2.getSessionName();
        this.myProgressWindow.setTitle(this.myTitle);
    }
}

