/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class XBreakpointPackageGroup
extends XBreakpointGroup {
    private static final String DEFAULT_PACKAGE_NAME = DebuggerBundle.message((String)"default.package.name", (Object[])new Object[0]);
    private final String myPackageName;

    public XBreakpointPackageGroup(String packageName) {
        this.myPackageName = packageName;
    }

    public Icon getIcon(boolean isOpen) {
        return PlatformIcons.PACKAGE_ICON;
    }

    @NotNull
    public String getName() {
        String packageName = this.getPackageName();
        String string = StringUtil.isEmpty((String)packageName) ? DEFAULT_PACKAGE_NAME : packageName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/XBreakpointPackageGroup", "getName"));
        }
        return string;
    }

    @NotNull
    public String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/XBreakpointPackageGroup", "getPackageName"));
        }
        return string;
    }
}

