/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.DialogUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class MethodBreakpointPropertiesPanel
extends XBreakpointCustomPropertiesPanel<XBreakpoint<JavaMethodBreakpointProperties>> {
    private JCheckBox myWatchEntryCheckBox;
    private JCheckBox myWatchExitCheckBox;

    @NotNull
    public JComponent getComponent() {
        this.myWatchEntryCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.method.breakpoint.properties.panel.method.entry", (Object[])new Object[0]));
        this.myWatchExitCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.method.breakpoint.properties.panel.method.exit", (Object[])new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.myWatchEntryCheckBox);
        DialogUtil.registerMnemonic((AbstractButton)this.myWatchExitCheckBox);
        Box watchBox = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myWatchEntryCheckBox, "North");
        watchBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myWatchExitCheckBox, "North");
        watchBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        JPanel _panel0 = new JPanel(new BorderLayout());
        _panel0.add((Component)watchBox, "Center");
        _panel0.add(Box.createHorizontalStrut(3), "West");
        _panel0.add(Box.createHorizontalStrut(3), "East");
        _panel.add((Component)_panel0, "North");
        _panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)DebuggerBundle.message((String)"label.group.watch.events", (Object[])new Object[0]), (boolean)true));
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox toCheck = null;
                if (!MethodBreakpointPropertiesPanel.this.myWatchEntryCheckBox.isSelected() && !MethodBreakpointPropertiesPanel.this.myWatchExitCheckBox.isSelected()) {
                    Object source = e.getSource();
                    if (MethodBreakpointPropertiesPanel.this.myWatchEntryCheckBox.equals(source)) {
                        toCheck = MethodBreakpointPropertiesPanel.this.myWatchExitCheckBox;
                    } else if (MethodBreakpointPropertiesPanel.this.myWatchExitCheckBox.equals(source)) {
                        toCheck = MethodBreakpointPropertiesPanel.this.myWatchEntryCheckBox;
                    }
                    if (toCheck != null) {
                        toCheck.setSelected(true);
                    }
                }
            }
        };
        this.myWatchEntryCheckBox.addActionListener(listener2);
        this.myWatchExitCheckBox.addActionListener(listener2);
        JPanel jPanel = _panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/MethodBreakpointPropertiesPanel", "getComponent"));
        }
        return jPanel;
    }

    public void loadFrom(@NotNull XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/MethodBreakpointPropertiesPanel", "loadFrom"));
        }
        this.myWatchEntryCheckBox.setSelected(((JavaMethodBreakpointProperties)breakpoint.getProperties()).WATCH_ENTRY);
        this.myWatchExitCheckBox.setSelected(((JavaMethodBreakpointProperties)breakpoint.getProperties()).WATCH_EXIT);
    }

    public void saveTo(@NotNull XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/MethodBreakpointPropertiesPanel", "saveTo"));
        }
        boolean changed = ((JavaMethodBreakpointProperties)breakpoint.getProperties()).WATCH_ENTRY != this.myWatchEntryCheckBox.isSelected();
        ((JavaMethodBreakpointProperties)breakpoint.getProperties()).WATCH_ENTRY = this.myWatchEntryCheckBox.isSelected();
        changed = ((JavaMethodBreakpointProperties)breakpoint.getProperties()).WATCH_EXIT != this.myWatchExitCheckBox.isSelected() || changed;
        ((JavaMethodBreakpointProperties)breakpoint.getProperties()).WATCH_EXIT = this.myWatchExitCheckBox.isSelected();
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }
}

