/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.impl.watch.EvaluationDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiCodeFragment;
import com.sun.jdi.Value;
import org.jetbrains.annotations.Nullable;

public class WatchItemDescriptor
extends EvaluationDescriptor {
    @Nullable
    private final String myCustomName;

    public WatchItemDescriptor(Project project2, TextWithImports text) {
        this(project2, text, (String)null);
    }

    public WatchItemDescriptor(Project project2, TextWithImports text, @Nullable String customName) {
        super(text, project2);
        this.myCustomName = customName;
        this.setValueLabel("");
    }

    public WatchItemDescriptor(Project project2, TextWithImports text, Value value) {
        this(project2, text, value, null);
    }

    public WatchItemDescriptor(Project project2, TextWithImports text, Value value, @Nullable String customName) {
        super(text, project2, value);
        this.myCustomName = customName;
        this.setValueLabel("");
    }

    @Override
    public String getName() {
        String customName = this.myCustomName;
        return customName == null ? this.getEvaluationText().getText() : customName;
    }

    public void setNew() {
        this.myIsNew = true;
    }

    public void setEvaluationText(TextWithImports evaluationText) {
        if (!Comparing.equal((Object)this.getEvaluationText(), (Object)evaluationText)) {
            this.setLvalue(false);
        }
        this.myText = evaluationText;
        this.myIsNew = true;
        this.setValueLabel("");
    }

    @Override
    protected EvaluationContextImpl getEvaluationContext(EvaluationContextImpl evaluationContext) {
        return evaluationContext;
    }

    @Override
    protected PsiCodeFragment getEvaluationCode(StackFrameContext context) throws EvaluateException {
        return this.createCodeFragment(PositionUtil.getContextElement(context));
    }
}

